%define _libexecdir %_prefix/libexec

%def_disable clang
%def_without docs

Name: dtkcore
Version: 5.7.26
Release: alt1

Summary: Deepin tool kit core modules

License: LGPL-2.1+ and LGPL-3.0+
Group: Graphical desktop/Other
Url: https://github.com/linuxdeepin/dtkcore
VCS: https://github.com/linuxdeepin/dtkcore

# Source-url: %url/archive/%version/%name-%version.tar.gz
Source: %name-%version.tar
Patch0: %name-%version-%release.patch
Patch1: dtkcore-alt-uos.patch

Provides: libdtk5-core = %EVR
Obsoletes: libdtk5-core < %EVR
Provides: dtk5-core = %EVR
Obsoletes: dtk5-core < %EVR

BuildRequires(pre): rpm-build-ninja deepin-desktop-base rpm-macros-dqt5
BuildRequires: cmake rpm-build-python3 dtk6-common-devel libdtklog-devel gsettings-qt-devel libsystemd-devel dqt5-base-devel libuchardet-devel libspdlog-devel libicu-devel libdbus-devel
%if_enabled clang
BuildRequires: clang-devel lld-devel
%else
BuildRequires: gcc-c++
%endif
%if_with docs
BuildRequires: dqt5-base-doc
%endif

Requires: libdqt5-dbus = %_dqt5_version

%description
Deepin tool kit core modules.

%package -n lib%{name}5
Summary: Libraries for %name
Group: System/Libraries
Requires: libdqt5-core = %_dqt5_version

%description -n lib%{name}5
Deepin tool kit core modules.
Libraries for %name.

%package -n lib%name-devel
Summary: Development package for %name
Group: Development/KDE and QT
Provides: dtk5-core-devel = %EVR
Obsoletes: dtk5-core-devel < %EVR
Requires: dtkcore = %EVR

%description -n lib%name-devel
Header files and libraries for %name.

%if_with docs
%package doc
Summary: %name documantation
Group: Documentation
BuildArch: noarch
Provides: dtk5-core-doc = %EVR
Obsoletes: dtk5-core-doc < %EVR

%description doc
This package provides %name documantation.
%endif

%prep
%setup
%patch0 -p1
%patch1 -p1

%build
%if_enabled clang
export CC=clang CXX=clang++ LDFLAGS="-fuse-ld=lld $LDFLAGS"
%endif
export PATH=%_dqt5_bindir:$PATH
%cmake \
  -GNinja \
  -DCMAKE_BUILD_TYPE=RelWithDebInfo \
  -DCMAKE_PREFIX_PATH=%_dqt5_libdir/cmake \
  -DCMAKE_SKIP_INSTALL_RPATH:BOOL=no \
  -DCMAKE_INSTALL_RPATH=%_dqt5_libdir \
  -DCMAKE_INSTALL_LIBDIR=%_lib \
  -DDTK_VERSION=%version \
  -DLIBRARY_INSTALL_DIR=%_lib \
  -DD_DSG_APP_DATA_FALLBACK=/var/dsg/appdata \
  -DBUILD_WITH_SYSTEMD=ON \
%if_without docs
  -DBUILD_DOCS=OFF \
%endif
  -DMKSPECS_INSTALL_DIR=%_dqt5_archdatadir/mkspecs/modules/ \
  -DFEATURES_INSTALL_DIR=%_dqt5_archdatadir/mkspecs/features/ \
  #
cmake --build %_cmake__builddir -j%__nprocs

%install
%cmake_install

%files
%doc README.md LICENSE
%dir %_libexecdir/dtk5
%dir %_libexecdir/dtk5/DCore/
%_libexecdir/dtk5/DCore/bin/

%files -n lib%{name}5
%_libdir/lib%name.so.5*

%files -n lib%name-devel
%doc docs/Specification.md
%_libdir/lib%name.so
%dir %_includedir/dtk5/
%_includedir/dtk5/DCore/
%_dqt5_archdatadir/mkspecs/modules/qt_lib_dtkcore.pri
%_dqt5_archdatadir/mkspecs/features/dtk_install_dconfig.prf
%_libdir/cmake/DtkCore/
%_libdir/cmake/DtkCMake/
%_libdir/cmake/DtkTools/
%_libdir/cmake/DtkDConfig/
%_pkgconfigdir/dtkcore.pc

%if_with docs
%files doc
%_dqt5_datadir/doc/dtkcore.qch
%endif

%changelog
