%def_disable clang
%def_enable docs

Name: dtk6widget
Version: 6.0.46
Release: alt1

Summary: Deepin tool kit widget modules

License: LGPL-3.0-or-later
Group: Graphical desktop/Other
Url: https://github.com/linuxdeepin/dtk6widget
Vcs: https://github.com/linuxdeepin/dtk6widget

Packager: Leontiy Volodin <lvol@altlinux.org>

# Source-url: %url/archive/%version/%name-%version.tar.gz
Source: %name-%version.tar
Patch0: %name-%version-%release.patch
Patch1: dtk6widget-6.0.19-alt-pkgconfig-found-dqt6.patch

Provides: libdtk6-widget = %EVR
Obsoletes: libdtk6-widget < %EVR

# for webp (dci) icons
Requires: dqt6-imageformats

%if_enabled clang
BuildRequires(pre): clang-devel
%else
BuildRequires(pre): gcc-c++
%endif
BuildRequires(pre): rpm-build-ninja rpm-macros-dqt6
BuildRequires: cmake doxygen dtk6-common-devel libdtk6gui-devel dqt6-tools-devel libxcbutil-devel libstartup-notification-devel libXext-devel libXi-devel dqt6-svg-devel libcups-devel

%description
DtkWidget is Deepin graphical user interface for deepin desktop development.

%package -n lib%{name}6
Summary: Libraries for %name
Group: System/Libraries
Requires: libdqt6-core = %_dqt6_version
Requires: libdqt6-gui = %_dqt6_version
Requires: libdqt6-printsupport = %_dqt6_version
Requires: libdqt6-widgets = %_dqt6_version

%description -n lib%{name}6
DtkWidget is Deepin graphical user interface for deepin desktop development.
Libraries for %name.

%package -n lib%name-devel
Summary: Development package for %name
Group: Development/KDE and QT
Provides: dtk6-widget-devel = %EVR
Obsoletes: dtk6-widget-devel < %EVR

%description -n lib%name-devel
Header files and libraries for %name.

%package examples
Summary: Examples for %name
Group: Development/KDE and QT
Provides: dtk6-widget-examples = %EVR
Obsoletes: dtk6-widget-examples < %EVR

%description examples
DtkWidget is Deepin graphical user interface for deepin desktop development.
Examples for %name.

%if_enabled docs
%package doc
Summary: %name documantation
Group: Documentation
BuildArch: noarch
Provides: dtk6-widget-doc = %EVR
Obsoletes: dtk6-widget-doc < %EVR

%description doc
This package provides %name documantation.
%endif

%prep
%setup
%patch0 -p1
%patch1 -p1

%build
%if_enabled clang
export CC="clang"
export CXX="clang++"
export AR="llvm-ar"
export NM="llvm-nm"
export READELF="llvm-readelf"
%endif

%DQ6build \
  -DMKSPECS_INSTALL_DIR=%_dqt6_mkspecsdir/modules/ \
%if_enabled docs
  -DBUILD_DOCS=ON \
%else
  -DBUILD_DOCS=OFF \
%endif
  -DCMAKE_INSTALL_LIBDIR=%_lib \
  -DDTK_VERSION=%version \
  -DBUILD_PLUGINS=OFF \
#

%install
%DQ6install

%files
%doc README.md LICENSE CHANGELOG.md
%dir %_libdir/dtk6/
%dir %_libdir/dtk6/DWidget/
%_libdir/dtk6/DWidget/bin/
%dir %_datadir/dtk6/
%_datadir/dtk6/DWidget/

%files -n lib%{name}6
%_libdir/lib%name.so.6*

%files -n lib%name-devel
%dir %_includedir/dtk6/
%_includedir/dtk6/DWidget/
%_dqt6_mkspecsdir/modules/*.pri
%_libdir/cmake/Dtk6Widget/
%_pkgconfigdir/%name.pc
%_libdir/lib%name.so

%files examples
%dir %_libdir/dtk6/DWidget/
%_libdir/dtk6/DWidget/examples/

%files doc
%_dqt6_docdir/dtkwidget.qch

%changelog
