%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%define flavour glibc
%if %flavour == "musl"
%def_enable static
%define pkgname dropbear-musl
%else
%def_disable static
%define pkgname dropbear
%endif

Name: %pkgname
Summary: A smallish SSH server and client
Version: 2025.88
Release: alt2
License: MIT
# "Dropbear is open source software, distributed under a MIT-style license."
Group: System/Servers
Url: https://matt.ucc.asn.au/dropbear/dropbear.html
Vcs: https://github.com/mkj/dropbear
%if_enabled static
Conflicts: dropbear
Provides: dropbear-static = %EVR
%endif

Source: dropbear-%version.tar
Source2: dropbear.service
Source3: dropbear.sysconfig

%if_enabled static
BuildRequires: musl-devel-static-import >= 1.2.5-alt7
BuildRequires: zlib-devel-static
%else
BuildRequires: zlib-devel
%endif
%{?!_without_check:%{?!_disable_check:
BuildRequires: iproute2
BuildRequires: python3-module-asyncssh
BuildRequires: python3-module-psutil
BuildRequires: python3-module-pytest-rerunfailures
BuildRequires: rpm-build-vm
BuildRequires: /usr/bin/pytest3
BuildRequires: /usr/bin/ssh-keygen
}}

%description
Dropbear is a relatively small SSH 2 server.

%package scp
Summary: Standalone scp program from OpenSSH
Group: %group
%if_enabled static
Conflicts: dropbear-scp
%endif
Conflicts: openssh-common

%description scp
The Dropbear distribution includes a standalone version of OpenSSH's scp
program.

%prep
%setup -n dropbear-%version
cat > localoptions.h <<EOF
#define SFTPSERVER_PATH "/usr/lib/openssh/sftp-server"
EOF
sed -i '/LDFLAGS/s/-static/-static-pie/' Makefile.in

%build
%if_enabled static
export CC=musl-gcc
%endif
# --disable-harden: We have hardening enabled in GCC by default.
%ifarch x86_64 %ix86
# Additional upstream hardening for x86.
%add_optflags -mfunction-return=thunk -mindirect-branch=thunk
%endif
%configure \
	--disable-harden \
	%{subst_enable static}
%make_build all scp SCPPROGRESS=1

%install
%makeinstall
install -D -m 0755 scp %buildroot%_bindir/scp
mkdir -p %buildroot%_sysconfdir/dropbear
install -Dpm644 %SOURCE2 %buildroot%_unitdir/dropbear.service
install -Dpm644 %SOURCE3 %buildroot%_sysconfdir/sysconfig/dropbear

%check
ldd ./dropbear ./dropbearkey ./dbclient ./dropbearconvert ./scp
%if_enabled static
file ./dropbear | grep 'LSB pie executable, .*, static-pie linked'
%else
file ./dropbear | grep 'LSB pie executable,.*, dynamically linked, interpreter.*ld-linux'
%endif
./dropbear -V |& grep -Fx 'Dropbear v%version'
./dropbearkey || : 'Listed key algorithms'
./dbclient -c help || : 'Listed ciphers'
./dbclient -m help || : 'Listed MACs'
./dropbearkey -t rsa -f dropbear_rsa_host_key
./dropbearkey -t ecdsa -f dropbear_ecdsa_host_key
./dropbearkey -t ed25519 -f dropbear_ed25519_host_key
# Upstream tend to enable DSS (ignoring config).
! ./dropbearkey | grep -iw DSS || exit 1
# Upstream testsuite.
vm-run --ext4 --heredoc <<-EOF
  cd test
  make fakekey
  HOME=/root
  mkdir -p ~/.ssh
  ../dropbearkey -t ecdsa -f ~/.ssh/id_dropbear | grep ^ecdsa > ~/.ssh/authorized_keys
  ../dropbearconvert dropbear openssh ~/.ssh/id_dropbear ~/.ssh/id_ecdsa
  chmod 700 ~/.ssh ~/.ssh/authorized_keys
  pytest3 --reruns=3 --hostkey=fakekey --dbclient=../dbclient --dropbear=../dropbear
EOF

%post
%post_service dropbear

%preun
%preun_service dropbear

%files
%define _customdocdir %_docdir/dropbear
%doc [A-Z][A-Z]*
%_bindir/dbclient
%_bindir/dropbearconvert
%_bindir/dropbearkey
%_sbindir/dropbear
%dir %_sysconfdir/dropbear
%config(noreplace) %_sysconfdir/sysconfig/dropbear
%_unitdir/dropbear.service
%_mandir/*/*

%files scp
%_bindir/scp

%changelog
