%define githash 71c8bcff6ea77a022b272a7eba649a774251bac4
%define gitdiff c6e62702d5e4fb2cf6b3fa27e67cb0d4b399a30b
%define _localstatedir %_var
%global optflags_lto %optflags_lto -ffat-lto-objects
# Fake unmet detection:
%filter_from_requires /^.usr.lib.lsb.init-functions/d

Name: drbd-utils
Version: 9.33.0
Release: alt1

Summary: DRBD user-land tools and scripts
License: GPLv2+
Group: System/Kernel and hardware

Url: http://www.drbd.org/
Source0: %name-%version.tar
Source1: %name-headers-%version.tar
Patch0: %name-%version-%release.patch

%define check_arches x86_64 %ix86
%ifarch %check_arches
%def_with check
%else
%def_without check
%endif


BuildRequires: docbook-style-xsl flex xsltproc
BuildRequires: gcc-c++ po4a udev libudev-devel libsystemd-devel
BuildRequires: asciidoctor resource-agents
BuildRequires: libkeyutils-devel
BuildRequires: jq
%{?!_without_check:%{?!_disable_check:BuildRequires: /proc clitest}}

Requires: linux-ha-common

Conflicts: drbd-tools drbd83-tools
Provides: %name-bash-completion = %EVR
Obsoletes: %name-bash-completion < %EVR
Obsoletes: drbd-xen <= 9.30.0
Obsoletes: drbd-rgmanager <= 9.31.0
Obsoletes: drbd-heartbeat <= 9.31.0

%description
DRBD refers to block devices designed as a building block to form high
availability (HA) clusters. This is done by mirroring a whole block device
via an assigned network. DRBD can be understood as network based raid-1.

This packages includes the DRBD administration tools.

%package pacemaker
Summary: Pacemaker resource agent for DRBD
Group: System/Kernel and hardware
Requires: %name = %version-%release
Requires: pacemaker
License: GPLv2
BuildArch: noarch

%description pacemaker
This package contains the master/slave DRBD resource agent for the
Pacemaker High Availability cluster manager.

%prep
%setup -a1
tar -xf %SOURCE1 -C drbd-headers
%patch0 -p1
(echo -e "#define GITHASH \"%githash\""; \
 echo -e "#define GITDIFF \"%gitdiff\"") > user/shared/drbd_buildtag.h
%ifarch %e2k
# lcc 1.25.15 barfs at DrbdRole.cpp:36, DrbdVolume.cpp:748
sed -i 's,-Wshadow,,' user/drbdmon/Makefile*
%endif

%build
%autoreconf
%configure \
    --with-initscripttype=both \
    --with-udev \
    --with-pacemaker \
    --with-distro=generic

# Bug in configure.ac, enabling WITH_DRBDMON anyway:
sed -i "s|WITH_DRBDMON[[:space:]]*=[[:space:]]*no|WITH_DRBDMON = yes|" \
  Makefile user/drbdmon/Makefile documentation/common/Makefile_v9_com
# Bug in compiler option:
sed -i "s|--pedantic-errors|-pedantic-errors|" user/drbdmon/Makefile

# Merged /lib and /usr/lib:
sed -i 's|)/lib/drbd/|)/usr/lib/drbd/|g' scripts/Makefile.in user/v84/Makefile.in

%make_build

%install
%makeinstall_std

rm -rf %buildroot%_mandir/ja
rm -f  %buildroot/etc/init.d/drbd	# NB: _not_ %%_initdir here
pushd scripts
%makeinstall_std
install -pDm755 drbd %buildroot%_initdir/drbd
rm -v %buildroot%_sysconfdir/init.d/drbd
rmdir -v %buildroot%_sysconfdir/init.d
popd

%post
%post_service drbd

%preun
%preun_service drbd

%check
make test

%files
%doc scripts/drbd.conf.example COPYING ChangeLog README.md
%config(noreplace) %_sysconfdir/drbd.conf
%dir %_sysconfdir/drbd.d
%config(noreplace) %_sysconfdir/drbd.d/global_common.conf
%config(noreplace) %_sysconfdir/multipath/conf.d/drbd.conf
%_initdir/drbd
%_presetdir/50-drbd.preset
%_unitdir/drbd.service
%_unitdir/drbd-graceful-shutdown.service
%_unitdir/drbd-lvchange@.service
%_unitdir/drbd-promote@.service
%_unitdir/drbd-reconfigure-suspend-or-error@.service
%_unitdir/drbd-demote-or-escalate@.service
%_unitdir/drbd-services@.target
%_unitdir/drbd-wait-promotable@.service
%_unitdir/drbd@.service
%_unitdir/drbd@.target
%_unitdir/drbd-configured.target
%_tmpfilesdir/drbd.conf
%_sbindir/drbdsetup
%_sbindir/drbdadm
%_sbindir/drbdmeta
%_sbindir/drbdmon
%_sbindir/drbd-events-log-supplier
%dir /usr/lib/drbd
/usr/lib/drbd/drbdadm-*
/usr/lib/drbd/drbdsetup-*
%dir /usr/lib/drbd/scripts
/usr/lib/drbd/scripts/drbd
/usr/lib/drbd/scripts/drbd-service-shim.sh
/usr/lib/drbd/scripts/drbd-wait-promotable.sh
/usr/lib/udev/rules.d/65-drbd.rules
%exclude /usr/lib/drbd/crm-*fence-peer.sh
%exclude /usr/lib/drbd/stonith_admin-fence-peer.sh
/usr/lib/drbd/*.sh
%dir %_var/lib/drbd
%_man8dir/drbd*
%_man7dir/*
%exclude %_man7dir/ocf_linbit_drbd.*
%exclude %_man7dir/ocf_linbit_drbd-attr.*
%_man5dir/drbd*
%_datadir/bash-completion/completions/drbdadm

%files pacemaker
%dir /usr/lib/ocf/resource.d/linbit
/usr/lib/ocf/resource.d/linbit/drbd
/usr/lib/ocf/resource.d/linbit/drbd.shellfuncs.sh
/usr/lib/ocf/resource.d/linbit/drbd-attr
/usr/lib/drbd/crm-*fence-peer.sh
/usr/lib/drbd/stonith_admin-fence-peer.sh
%_man7dir/ocf_linbit_drbd.*
%_man7dir/ocf_linbit_drbd-attr.*

%changelog
