%define qdoc_found %{expand:%%(if [ -e %_dqt5_bindir/qdoc ]; then echo 1; else echo 0; fi)}
%global qt_module dqtscript

%define optflags_lto %nil

Name: dqt5-script
Version: 5.15.13
Release: alt0.dde.1

Group: System/Libraries
Summary: Qt5 - QtScript component
Url: http://qt.io/
License: LGPLv2 / GPLv3

Source: %qt_module-everywhere-src-%version.tar
Patch1: alt-loongarch64.patch

BuildRequires(pre): rpm-build-ubt rpm-macros-dqt5 dqt5-tools
BuildRequires: gcc-c++ glibc-devel dqt5-base-devel

# find libraries
%add_findprov_lib_path %_dqt5_libdir

%description
%summary.

%package common
Summary: Common package for %name
Group: System/Configuration/Other
BuildArch: noarch
Requires: dqt5-base-common
%description common
Common package for %name

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
Requires: %name-common = %EVR
Requires: dqt5-base-devel
%description devel
%summary.

%package devel-static
Group: Development/KDE and QT
Summary: Development files for %name
Requires: %name-common = %EVR
Requires: %name-devel
%description devel-static
%summary.

%package doc
Summary: Document for developing apps which will use Qt5 %qt_module
Group: Development/KDE and QT
Requires: %name-common = %EVR
%description doc
This package contains documentation for Qt5 %qt_module

%package -n libdqt5-script
Summary: Qt5 library
Group: System/Libraries
Requires: %name-common = %EVR
Requires: libdqt5-core = %_dqt5_version libdqt5-widgets = %_dqt5_version
%description -n libdqt5-script
%summary

%prep
%setup -qn %qt_module-everywhere-src-%version
%patch1 -p1
sed -i -E 's|MODULE_VERSION[[:space:]]+.*$|MODULE_VERSION = %version|' .qmake.conf
syncqt.pl-dqt5 -version %version

# workaround against gcc8
%if "%__gcc_version_major" == "8"
#sed -i 's|^asm volatile ($|asm (|' src/3rdparty/javascriptcore/JavaScriptCore/jit/JITStubs.cpp
%endif

%build
%qmake_dqt5
%make_build
%if %qdoc_found
export QT_HASH_SEED=0
%make docs
%endif

%install
%install_dqt5
%make INSTALL_ROOT=%buildroot install_docs ||:

%files common
%files -n libdqt5-script
%_dqt5_libdir/libQt5Script.so.*
%_dqt5_libdir/libQt5ScriptTools.so.*

%files devel
%_dqt5_headerdir/Qt*/
%_dqt5_libdir/libQt5*.so
%_dqt5_libdatadir/libQt5*.so
%_dqt5_libdir/libQt*.prl
%_dqt5_libdatadir/libQt*.prl
%_dqt5_libdir/cmake/Qt*/
%_dqt5_libdir/pkgconfig/Qt*.pc
%_dqt5_archdatadir/mkspecs/modules/*.pri

%files doc
%if %qdoc_found
%_dqt5_docdir/*
%endif
%_dqt5_examplesdir/*

%changelog
