%define _unpackaged_files_terminate_build 1

# Add option to build without examples
%def_without examples
# Add option to build without tools
%def_with tools
%def_disable docs

%def_enable afxdp

Name: dpdk
Version: 23.11.4
Release: alt1
Url: http://dpdk.org
License: BSD-3-Clause AND GPL-2.0-only AND LGPL-2.1-only
Summary: Set of libraries and drivers for fast packet processing
Group: System/Libraries

Source: %name-%version.tar

Patch0001: 0001-Do-not-redefine-strlcpy-and-strlcat.patch

#
# The DPDK is designed to optimize througput of network traffic using, among
# other techniques, carefully crafted assembly instructions.  As such it
# needs extensive work to port it to other architectures.
#
ExclusiveArch: x86_64 %{ix86} aarch64 ppc64le riscv64 loongarch64

BuildRequires(pre): meson >= 0.53.2
BuildRequires(pre): rpm-build-python3
BuildRequires: glibc-kernheaders libpcap-devel zlib-devel libssl-devel libisal-devel
BuildRequires: libnuma-devel libelf-devel libfdt-devel libjansson-devel
BuildRequires: rdma-core-devel libmnl-devel python3(elftools)
%{?_enable_afxdp:BuildRequires: libbpf-devel libxdp-devel}
%{?_enable_docs:BuildRequires: doxygen /usr/bin/sphinx-build python3-module-sphinx_rtd_theme}
Requires: lib%name = %EVR

%description
The Data Plane Development Kit is a set of libraries and drivers for
fast packet processing in the user space.

%package -n lib%name
Summary: Data Plane Development Kit runtime libraries
Group: System/Libraries

%description -n lib%name
This package contains the runtime libraries needed for 3rd party application
to use the Data Plane Development Kit.

%package devel
Summary: Data Plane Development Kit development files
Group: System/Libraries
Provides: lib%name-devel = %EVR
Requires: %name = %EVR
Requires: pkgconfig(libmlx5) pkgconfig(libibverbs) pkgconfig(libcrypto)
Requires: pkgconfig(libxdp) >= 1.2.2 pkgconfig(libbpf) pkgconfig(zlib)
Requires: pkgconfig(jansson) pkgconfig(libmana) pkgconfig(libmlx4)
Requires: pkgconfig(libpcap) pkgconfig(libisal) pkgconfig(libelf)

%description devel
This package contains the headers and other files needed for developing
applications with the Data Plane Development Kit.

%package doc
Summary: Data Plane Development Kit API documentation
Group: System/Libraries
BuildArch: noarch

%description doc
API programming documentation for the Data Plane Development Kit.

%package tools
Summary: Tools for setting up Data Plane Development Kit environment
Group: Development/Documentation
Requires: %name = %EVR
Requires: kmod pciutils findutils iproute
AutoReqProv: yes, nopython

%description tools
%summary

%package examples
Summary: Data Plane Development Kit example applications
Group: Development/Tools
BuildRequires: libvirt-devel

%description examples
Example applications utilizing the Data Plane Development Kit, such
as L2 and L3 forwarding.

%define sdkdir %_datadir/%name
%define docdir %_docdir/%name
%define incdir %_includedir/%name
%define pmddir %name-pmds

%prep
%setup
%patch0001 -p2

%build
%add_optflags -fcommon
%meson --includedir=include/dpdk \
       -Ddrivers_install_subdir=%pmddir \
       -Dmachine=default \
       %{?_with_examples:-Dexamples=all} \
       %{?_enable_docs:-Denable_docs=true} \
       --default-library=shared

%meson_build

%install
%meson_install
rm -f %buildroot%_libdir/*.a

%files
# BSD
%ifnarch %{ix86}
%_bindir/dpdk-dumpcap
%endif
%_bindir/dpdk-testpmd
%_bindir/dpdk-proc-info

%files -n lib%name
%_libdir/*.so.*
%_libdir/%pmddir

%if_enabled docs
%files doc
#BSD
%docdir
%endif

%files devel
#BSD
%incdir/
%sdkdir
%if_with examples
%exclude %sdkdir/examples/
%endif
%_libdir/*.so
%_pkgconfigdir/*.pc

%if_with tools
%files tools
%ifnarch %{ix86}
%_bindir/dpdk-pdump
%endif
%_bindir/dpdk-graph
%_bindir/dpdk-test
%_bindir/dpdk-test-*
%_bindir/dpdk-*.py
%endif

%if_with examples
%files examples
%_bindir/dpdk_example_*
%doc %sdkdir/examples
%endif

%changelog
