%define _unpackaged_files_terminate_build 1

%def_with check
%def_without javadoc

%define pki_username pkiuser
%define pki_groupname pkiuser
%define pki_homedir %_localstatedir/pki

%define java_home %_jvmdir/jre

%define jss_version 5.6.0
%define ldapjdk_version 5.6.0
%define tomcat_version 9.0.62

%define java_version 21

# first dogtag-pki renamed from pki-core
%define pki_rebranded_version 11.0.0-alt1

Name: dogtag-pki
Version: 11.6.1
Release: alt1
Summary: Dogtag PKI Certificate System
License: %gpl2only
Group: System/Servers
Url: http://www.dogtagpki.org
Vcs: https://github.com/dogtagpki/pki
Source: %name-%version.tar
Source1: dogtag-pki-base.filetrigger
Patch: %name-%version-alt.patch

# - upstream doesn't support i586 (Fedora's Java 17 is not built for that arch)
# - ALT's Java 17 is not built for armh
ExcludeArch: %ix86 armh

BuildRequires(pre): rpm-build-licenses

BuildRequires: gcc-c++
BuildRequires: cmake
BuildRequires: sh4
BuildRequires: libldap-devel
BuildRequires: libapr1-devel

BuildRequires: libnss-devel

# java deps
BuildRequires(pre): rpm-macros-java
BuildRequires: java-devel >= %java_version
BuildRequires: maven-local
# https://bugzilla.altlinux.org/53331
# BuildRequires: mvn(org.apache.tomcat:tomcat-servlet-api) >= %tomcat_version
BuildRequires: tomcat-servlet-4.0-api >= %tomcat_version
BuildRequires: mvn(commons-cli:commons-cli)
BuildRequires: mvn(commons-codec:commons-codec)
BuildRequires: mvn(commons-io:commons-io)
BuildRequires: mvn(commons-logging:commons-logging)
BuildRequires: mvn(commons-net:commons-net)
BuildRequires: mvn(org.apache.commons:commons-lang3)
BuildRequires: mvn(org.apache.httpcomponents:httpclient)
BuildRequires: mvn(org.slf4j:slf4j-api)
BuildRequires: mvn(xml-apis:xml-apis)
BuildRequires: mvn(xml-resolver:xml-resolver)
BuildRequires: mvn(org.junit.jupiter:junit-jupiter-api)
BuildRequires: mvn(jakarta.activation:jakarta.activation-api)
BuildRequires: mvn(jakarta.annotation:jakarta.annotation-api)
BuildRequires: mvn(jakarta.xml.bind:jakarta.xml.bind-api)
BuildRequires: mvn(com.fasterxml.jackson.core:jackson-annotations)
BuildRequires: mvn(com.fasterxml.jackson.core:jackson-core)
BuildRequires: mvn(com.fasterxml.jackson.core:jackson-databind)
BuildRequires: mvn(com.fasterxml.jackson.module:jackson-module-jaxb-annotations)
BuildRequires: mvn(com.fasterxml.jackson.jaxrs:jackson-jaxrs-base)
BuildRequires: mvn(com.fasterxml.jackson.jaxrs:jackson-jaxrs-json-provider)
BuildRequires: mvn(org.jboss.spec.javax.ws.rs:jboss-jaxrs-api_2.0_spec)
BuildRequires: mvn(org.jboss.logging:jboss-logging)
BuildRequires: mvn(org.jboss.resteasy:resteasy-jaxrs)
BuildRequires: mvn(org.jboss.resteasy:resteasy-client)
BuildRequires: mvn(org.jboss.resteasy:resteasy-jackson2-provider)
BuildRequires: mvn(org.jboss.resteasy:resteasy-servlet-initializer)
BuildRequires: mvn(org.apache.tomcat:tomcat-catalina) >= %tomcat_version
BuildRequires: mvn(org.apache.tomcat:tomcat-jaspic-api) >= %tomcat_version
BuildRequires: mvn(org.apache.tomcat:tomcat-util-scan) >= %tomcat_version
BuildRequires: mvn(org.dogtagpki.jss:jss-base) >= %jss_version
BuildRequires: mvn(org.dogtagpki.jss:jss-tomcat) >= %jss_version
BuildRequires: mvn(org.dogtagpki.ldap-sdk:ldapjdk) >= %ldapjdk_version

# python deps
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

# build dependency to build man pages
BuildRequires: go-md2man
BuildRequires: python3-module-sphinx
# used by sphinx to generate docs and mans
BuildRequires: python3-module-cryptography
BuildRequires: python3-module-ldap

# used by dogtag-pki-server-theme
BuildRequires: fonts-font-awesome

# mark upgrade code as Python3 code
%add_python3_path %_datadir/pki/upgrade/
%add_python3_path %_datadir/pki/server/upgrade/
%add_python3_compile_exclude %_datadir/pki/upgrade/
%add_python3_compile_exclude %_datadir/pki/server/upgrade/

#### Meta package ####
Requires: dogtag-pki-server-theme
Requires: python3-module-dogtag-pki
Requires: dogtag-pki-java
Requires: dogtag-pki-tools
Requires: dogtag-pki-server
Requires: dogtag-pki-acme
Requires: dogtag-pki-ca
Requires: dogtag-pki-kra
Requires: dogtag-pki-ocsp
Requires: dogtag-pki-tks
Requires: dogtag-pki-tps
Requires: dogtag-pki-est

# removed from Sisyphus
Obsoletes: idm-console-framework <= 1.2.0-alt1
Obsoletes: pki-console < 11.0.0
Obsoletes: dogtag-pki-console-theme < 11.0.0
Obsoletes: dogtag-pki-symkey < 11.1.0-alt1

Provides: pki-core = %EVR
Obsoletes: pki-core < %pki_rebranded_version

%description
Dogtag PKI is an enterprise software system designed
to manage enterprise Public Key Infrastructure deployments.

Dogtag PKI consists of the following components:

  * Automatic Certificate Management Environment (ACME) Responder
  * Certificate Authority (CA)
  * Key Recovery Authority (KRA)
  * Online Certificate Status Protocol (OCSP) Manager
  * Token Key Service (TKS)
  * Token Processing Service (TPS)


%package -n dogtag-pki-base
Summary: Dogtag PKI Base Package
Group: System/Base
Requires: python3-module-dogtag-pki
Provides: pki-base = %EVR
Obsoletes: pki-base < %pki_rebranded_version
Requires(post): python3-module-dogtag-pki

%description -n dogtag-pki-base
The Dogtag PKI Base Package contains the common and client libraries
and utilities written in Python.

%package -n dogtag-pki-java
Summary: Dogtag PKI Base Java Package
Group: System/Base
Requires: dogtag-pki-base
Requires: java >= %java_version
Provides: pki-base-java = %EVR
Obsoletes: pki-base-java < %pki_rebranded_version

Provides: dogtag-pki-base-java = %EVR
Obsoletes: dogtag-pki-base-java < 11.1.0-alt1

%description -n dogtag-pki-java
The Dogtag PKI Base Java Package contains the common and client
libraries and utilities written in Java.

%package -n python3-module-dogtag-pki
Summary: Dogtag PKI Python3 Package
Group: Development/Python3
Requires: dogtag-pki-base
Provides: python3-module-pki-base = %EVR
Obsoletes: python3-module-pki-base < %pki_rebranded_version

%description -n python3-module-dogtag-pki
This package contains Dogtag PKI client library for Python3.

%package -n dogtag-pki-tools
Summary: Dogtag PKI Tools Package
Group: System/Base
Requires: dogtag-pki-java
Requires: openldap-clients
Requires: nss-utils
Requires: p11-kit-trust
Provides: pki-tools = %EVR
Obsoletes: pki-tools < %pki_rebranded_version

%description -n dogtag-pki-tools
This package contains Dogtag PKI executables that can be used to help make
Certificate System into a more complete and robust PKI solution.

The utility "tpsclient" is a test tool that interacts with TPS.
This tool is useful to test TPS server without risking an actual smart card.

%package -n dogtag-pki-server
Summary: Dogtag PKI Server Package
Group: System/Base
Requires: dogtag-pki-tools
Requires: openssl
Requires: tomcat >= %tomcat_version
Requires: mvn(org.dogtagpki.jss:jss-tomcat) >= %jss_version
Provides: pki-server = %EVR
Obsoletes: pki-server < %pki_rebranded_version

# https://pagure.io/freeipa/issue/7742
Conflicts: freeipa-server < 4.7.1

%description -n dogtag-pki-server
The Dogtag PKI Server Package contains libraries and utilities needed by other
Dogtag PKI subsystems.

%package -n dogtag-pki-acme
Summary: Dogtag PKI ACME Package
Group: System/Base
Requires: dogtag-pki-server
Provides: pki-acme = %EVR
Obsoletes: pki-acme < %pki_rebranded_version

%description -n dogtag-pki-acme
The Dogtag PKI ACME responder is a service that provides an automatic
certificate management via ACME v2 protocol defined in RFC 8555.

%package -n dogtag-pki-ca
Summary: Dogtag PKI CA Package
Group: System/Servers
Requires: dogtag-pki-server
Provides: pki-ca = %EVR
Obsoletes: pki-ca < %pki_rebranded_version

%description -n dogtag-pki-ca
The Certificate Authority (CA) is a required Dogtag PKI subsystem which issues,
renews, revokes, and publishes certificates as well as compiling and
publishing Certificate Revocation Lists (CRLs).

The Certificate Authority can be configured as a self-signing Certificate
Authority, where it is the root CA, or it can act as a subordinate CA,
where it obtains its own signing certificate from a public CA.

%package -n dogtag-pki-est
Summary: Dogtag PKI EST Package
Group: System/Servers
Requires: dogtag-pki-server

%description -n dogtag-pki-est
Dogtag PKI EST subsystem provides an Enrollment over Secure Transport (RFC 7030)
service.

%package -n dogtag-pki-kra
Summary: Dogtag PKI KRA Package
Group: System/Servers
Requires: dogtag-pki-server
Provides: pki-kra = %EVR
Obsoletes: pki-kra < %pki_rebranded_version

%description -n dogtag-pki-kra
The Key Recovery Authority (KRA) is an optional Dogtag PKI subsystem that can
act as a key archival facility.  When configured in conjunction with the
Certificate Authority (CA), the KRA stores private encryption keys as part of
the certificate enrollment process.  The key archival mechanism is triggered
when a user enrolls in the Dogtag PKI and creates the certificate request.
Using the Certificate Request Message Format (CRMF) request format, a request
is generated for the user's private encryption key.  This key is then stored in
the KRA which is configured to store keys in an encrypted format that can only
be decrypted by several agents requesting the key at one time, providing for
protection of the public encryption keys for the users in the Dogtag PKI
deployment.

Note that the KRA archives encryption keys; it does NOT archive signing keys,
since such archival would undermine non-repudiation properties of signing keys.

%package -n dogtag-pki-ocsp
Summary: Dogtag PKI OCSP Package
Group: System/Servers
Requires: dogtag-pki-server
Provides: pki-ocsp = %EVR
Obsoletes: pki-ocsp < %pki_rebranded_version

%description -n dogtag-pki-ocsp
The Online Certificate Status Protocol (OCSP) Manager is an optional Dogtag PKI
subsystem that can act as a stand-alone OCSP service.  The OCSP Manager
performs the task of an online certificate validation authority by enabling
OCSP-compliant clients to do real-time verification of certificates.  Note
that an online certificate-validation authority is often referred to as an
OCSP Responder.

Although the Certificate Authority (CA) is already configured with an
internal OCSP service.  An external OCSP Responder is offered as a separate
subsystem in case the user wants the OCSP service provided outside of a
firewall while the CA resides inside of a firewall, or to take the load of
requests off of the CA.

The OCSP Manager can receive Certificate Revocation Lists (CRLs) from
multiple CA servers, and clients can query the OCSP Manager for the
revocation status of certificates issued by all of these CA servers.

When an instance of OCSP Manager is set up with an instance of CA, and
publishing is set up to this OCSP Manager, CRLs are published to it
whenever they are issued or updated.

%package -n dogtag-pki-tks
Summary: Dogtag PKI TKS Package
Group: System/Servers
Requires: dogtag-pki-server
Provides: pki-tks = %EVR
Obsoletes: pki-tks < %pki_rebranded_version

%description -n dogtag-pki-tks
The Token Key Service (TKS) is an optional Dogtag PKI subsystem that manages
the master key(s) and the transport key(s) required to generate and distribute
keys for hardware tokens.  TKS provides the security between tokens and an
instance of Token Processing System (TPS), where the security relies upon the
relationship between the master key and the token keys.  A TPS communicates
with a TKS over SSL using client authentication.

TKS helps establish a secure channel (signed and encrypted) between the token
and the TPS, provides proof of presence of the security token during
enrollment, and supports key changeover when the master key changes on the
TKS.  Tokens with older keys will get new token keys.

Because of the sensitivity of the data that TKS manages, TKS should be set up
behind the firewall with restricted access.

%package -n dogtag-pki-tps
Summary: Dogtag PKI TPS Package
Group: System/Servers
Requires: dogtag-pki-server
Provides: pki-tps = %EVR
Obsoletes: pki-tps < %pki_rebranded_version

%description -n dogtag-pki-tps
The Token Processing System (TPS) is an optional Dogtag PKI subsystem that acts
as a Registration Authority (RA) for authenticating and processing
enrollment requests, PIN reset requests, and formatting requests from
the Enterprise Security Client (ESC).

TPS is designed to communicate with tokens that conform to
Global Platform's Open Platform Specification.

TPS communicates over SSL with various PKI backend subsystems (including
the Certificate Authority (CA), the Data Recovery Manager (DRM), and the
Token Key Service (TKS)) to fulfill the user's requests.

TPS also interacts with the token database, an LDAP server that stores
information about individual tokens.

%if_with javadoc
%package -n dogtag-pki-javadoc
Summary: Dogtag PKI Javadoc Package
Group: Documentation
Requires: javapackages-tools
Provides: pki-javadoc = %EVR
Obsoletes: pki-javadoc < %pki_rebranded_version

%description -n dogtag-pki-javadoc
This package contains Dogtag PKI API documentation.
%endif

%package -n dogtag-pki-healthcheck
Summary: Dogtag PKI Healthcheck
Group: System/Servers
Provides: pki-healthcheck = %EVR
Obsoletes: pki-healthcheck < %pki_rebranded_version

%description -n dogtag-pki-healthcheck
The healthcheck tool is intended for executing health checks against Dogtag
PKI. This is the plugin for freeipa-healthcheck.

%package -n dogtag-pki-server-theme
Summary: Dogtag PKI Server Theme Package
Group: Networking/Other
Provides: pki-server-theme = %EVR
Obsoletes: pki-server-theme < %EVR
Requires: fonts-font-awesome

%description -n dogtag-pki-server-theme
This Dogtag PKI Server Theme Package contains textual and graphical user
interface for Dogtag PKI Server.

%prep
%setup
%patch -p1
# change port from 8080 to 8090
# Port 8080 is used by alterator-ahttpd-server
grep -rEl '(\W|^)8080(\W|$)' | xargs sed -i 's/\(\W\|^\|\)8080\(\W\|$\)/\18090\2/g'
%python3_fix_shebang .

# remove plugins not needed to build RPM
%pom_remove_plugin org.codehaus.mojo:flatten-maven-plugin
%pom_remove_plugin org.apache.maven.plugins:maven-deploy-plugin
%pom_remove_plugin com.github.github:site-maven-plugin

# pki-console is disabled
%pom_disable_module console base

# specify Maven artifact locations
%mvn_file org.dogtagpki.pki:pki-common pki/pki-common
%mvn_file org.dogtagpki.pki:pki-tools pki/pki-tools
%mvn_file org.dogtagpki.pki:pki-server pki/pki-server
%mvn_file org.dogtagpki.pki:pki-server-webapp pki/pki-server-webapp
%mvn_file org.dogtagpki.pki:pki-tomcat pki/pki-tomcat
%mvn_file org.dogtagpki.pki:pki-tomcat-9.0 pki/pki-tomcat-9.0
%mvn_file org.dogtagpki.pki:pki-ca pki/pki-ca
%mvn_file org.dogtagpki.pki:pki-kra pki/pki-kra
%mvn_file org.dogtagpki.pki:pki-ocsp pki/pki-ocsp
%mvn_file org.dogtagpki.pki:pki-tks pki/pki-tks
%mvn_file org.dogtagpki.pki:pki-tps pki/pki-tps
%mvn_file org.dogtagpki.pki:pki-acme pki/pki-acme
%mvn_file org.dogtagpki.pki:pki-est pki/pki-est

# specify Maven artifact packages
%mvn_package org.dogtagpki.pki:pki-common pki-java
%mvn_package org.dogtagpki.pki:pki-tools pki-tools
%mvn_package org.dogtagpki.pki:pki-server pki-server
%mvn_package org.dogtagpki.pki:pki-server-webapp pki-server
%mvn_package org.dogtagpki.pki:pki-tomcat pki-server
%mvn_package org.dogtagpki.pki:pki-tomcat-9.0 pki-server
%mvn_package org.dogtagpki.pki:pki-ca pki-ca
%mvn_package org.dogtagpki.pki:pki-kra pki-kra
%mvn_package org.dogtagpki.pki:pki-ocsp pki-ocsp
%mvn_package org.dogtagpki.pki:pki-tks pki-tks
%mvn_package org.dogtagpki.pki:pki-tps pki-tps
%mvn_package org.dogtagpki.pki:pki-acme pki-acme
%mvn_package org.dogtagpki.pki:pki-est pki-est

%build
%mvn_build

# build native binaries with CMake
app_server=tomcat-9.0
%add_optflags -I/usr/include/apu-1
%cmake \
    -DVERSION=%version \
    -DRELEASE=%release \
    -DVAR_INSTALL_DIR:PATH=%_var \
    -DP11_KIT_TRUST=%_libdir/libnssckbi.so \
    -DJAVA_HOME=%java_home \
    -DSYSTEMD_LIB_INSTALL_DIR=%_unitdir \
    -DAPP_SERVER=$app_server \
    -DPYTHON_EXECUTABLE=%__python3 \
    -DRUN_TESTS:BOOL=OFF \
    -DWITH_TESTS:BOOL=OFF \
    -DWITH_JAVA=FALSE \
%if_with javadoc
    -DWITH_JAVADOC:BOOL=ON \
%else
    -DWITH_JAVADOC:BOOL=OFF \
%endif
    -DWITH_CONSOLE:BOOL=OFF \
    -DTHEME=dogtag \

%cmake_build -t all

%install
%mvn_install
%cmakeinstall_std

# from sem@:
# This file should be sourced only
chmod -x %buildroot%_datadir/pki/scripts/operations
touch %buildroot%_sysconfdir/pki/pki.version
touch %buildroot%_logdir/pki/pki-upgrade.log
touch %buildroot%_logdir/pki/pki-server-upgrade-%version.log
mkdir %buildroot%_logdir/pki/server
mkdir %buildroot%_logdir/pki/server/upgrade

# don't ship html docs
rm -r %buildroot%_datadir/doc/pki-base/html/

# since we package python modules as arch dependent
%if "%python3_sitelibdir" != "%python3_sitelibdir_noarch"
mkdir -p %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* %buildroot%python3_sitelibdir/
%endif

# install filetrigger
mkdir -p %buildroot%_rpmlibdir
install -D -p -m 0755 %SOURCE1 %buildroot%_rpmlibdir/dogtag-pki-base.filetrigger

%check

%pre -n dogtag-pki-server
%_sbindir/groupadd -r -f %pki_groupname ||:
%_sbindir/useradd -g %pki_groupname -c 'Certificate System' \
                  -d %pki_homedir -s /sbin/nologin -r %pki_username \
                  > /dev/null 2>&1 ||:

%post -n dogtag-pki-base
if [ $1 -eq 1 ]
then
    # On RPM installation create system upgrade tracker
    echo "Configuration-Version: %version" > %_sysconfdir/pki/pki.version
fi

%postun -n dogtag-pki-base
if [ $1 -eq 0 ]
then
    # On RPM uninstallation remove system upgrade tracker
    rm -f %_sysconfdir/pki/pki.version
fi

%post -n dogtag-pki-server
# upgrade
if [ "$1" -ge 2 ]
then
    # CVE-2021-3551: Remove world access from existing installation logs
    find %_logdir/pki -maxdepth 1 -type f -exec chmod o-rwx {} \;

    # pki-tomcat is the hardcoded instance name used by ipa
    # https://pagure.io/dogtagpki/issue/3195
    chown -R -P %pki_username:%pki_groupname \
        %_sysconfdir/pki/pki-tomcat/alias >/dev/null 2>&1 ||:

    systemctl daemon-reload ||:
fi

%files -f .mfiles
%doc %_docdir/pki/README

%files -n dogtag-pki-base
%doc %_datadir/pki/server/docs
%dir %_datadir/pki/etc
%dir %_datadir/pki/lib
%dir %_datadir/pki/scripts
%dir %_datadir/pki/examples
%dir %_logdir/pki
%_datadir/pki/VERSION
%_datadir/pki/pom.xml
%_datadir/pki/etc/pki.conf
%_datadir/pki/etc/logging.properties
%_datadir/pki/scripts/config
%_datadir/pki/upgrade/
%_datadir/pki/key/
%config(noreplace) %_sysconfdir/pki/pki.conf
%ghost %_sysconfdir/pki/pki.version
%ghost %_logdir/pki/pki-upgrade.log
%_sbindir/pki-upgrade
%_man1dir/pki-python-client.1.*
%_man5dir/pki-logging.5.*
%_man8dir/pki-upgrade.8.*
%_rpmlibdir/dogtag-pki-base.filetrigger

%files -n dogtag-pki-java -f .mfiles-pki-java
%_datadir/pki/examples/java/
%_datadir/pki/lib/*.jar

%files -n python3-module-dogtag-pki
%exclude %python3_sitelibdir/pki/server/
%python3_sitelibdir/pki/

%files -n dogtag-pki-tools -f .mfiles-pki-tools
%doc base/tools/doc/README
%_bindir/pistool
%_bindir/pki
%_bindir/revoker
%_bindir/setpin
%_bindir/tkstool
%_bindir/tpsclient
%_bindir/AtoB
%_bindir/AuditVerify
%_bindir/BtoA
%_bindir/CMCEnroll
%_bindir/CMCRequest
%_bindir/CMCResponse
%_bindir/CMCRevoke
%_bindir/CMCSharedToken
%_bindir/CRMFPopClient
%_bindir/ExtJoiner
%_bindir/GenExtKeyUsage
%_bindir/GenIssuerAltNameExt
%_bindir/GenSubjectAltNameExt
%_bindir/HttpClient
%_bindir/KRATool
%_bindir/OCSPClient
%_bindir/PKCS10Client
%_bindir/PKCS12Export
%_bindir/PKICertImport
%_bindir/PrettyPrintCert
%_bindir/PrettyPrintCrl
%_bindir/TokenInfo
%_datadir/pki/tools/
%_datadir/pki/lib/p11-kit-trust.so
%_man1dir/AtoB.1.*
%_man1dir/AuditVerify.1.*
%_man1dir/BtoA.1.*
%_man1dir/CMCEnroll.1.*
%_man1dir/CMCRequest.1.*
%_man1dir/CMCSharedToken.1.*
%_man1dir/CMCResponse.1.*
%_man1dir/KRATool.1.*
%_man1dir/PrettyPrintCert.1.*
%_man1dir/PrettyPrintCrl.1.*
%_man1dir/pki.1.*
%_man1dir/pki-audit.1.*
%_man1dir/pki-ca-cert.1.*
%_man1dir/pki-ca-kraconnector.1.*
%_man1dir/pki-ca-profile.1.*
%_man1dir/pki-client.1.*
%_man1dir/pki-group.1.*
%_man1dir/pki-group-member.1.*
%_man1dir/pki-kra-key.1.*
%_man1dir/pki-pkcs12-cert.1.*
%_man1dir/pki-pkcs12-key.1.*
%_man1dir/pki-pkcs12.1.*
%_man1dir/pki-securitydomain.1.*
%_man1dir/pki-tps-profile.1.*
%_man1dir/pki-user.1.*
%_man1dir/pki-user-cert.1.*
%_man1dir/pki-user-membership.1.*
%_man1dir/PKCS10Client.1.*
%_man1dir/PKICertImport.1.*
%_man1dir/tpsclient.1.*

%files -n dogtag-pki-server -f .mfiles-pki-server
%doc base/common/THIRD_PARTY_LICENSES
%doc base/server/LICENSE
%doc base/server/README
%dir %_sysconfdir/sysconfig/pki
%dir %_sysconfdir/sysconfig/pki/tomcat
%_sbindir/pkispawn
%_sbindir/pkidestroy
%_sbindir/pki-server
%python3_sitelibdir/pki/server/
%exclude %python3_sitelibdir/pki/server/healthcheck/

%_datadir/pki/etc/tomcat.conf
%dir %_datadir/pki/deployment
%_datadir/pki/deployment/config/
%_datadir/pki/scripts/operations
%_bindir/pkidaemon
%_bindir/pki-server-nuxwdog
%dir %_sysconfdir/systemd/system/pki-tomcatd.target.wants
%_unitdir/pki-tomcatd@.service
%_unitdir/pki-tomcatd.target
%dir %_sysconfdir/systemd/system/pki-tomcatd-nuxwdog.target.wants
%ghost %_logdir/pki/pki-server-upgrade-%version.log
%ghost %_logdir/pki/server/
%_unitdir/pki-tomcatd-nuxwdog@.service
%_unitdir/pki-tomcatd-nuxwdog.target
%dir %_sharedstatedir/pki
%_man1dir/pkidaemon.1.*
%_man5dir/pki_default.cfg.5.*
%_man5dir/pki-server-logging.5.*
%_man8dir/pki-server-upgrade.8.*
%_man8dir/pkidestroy.8.*
%_man8dir/pkispawn.8.*
%_man8dir/pki-server.8.*
%_man8dir/pki-server-acme.8.*
%_man8dir/pki-server-est.8.*
%_man8dir/pki-server-instance.8.*
%_man8dir/pki-server-subsystem.8.*
%_man8dir/pki-server-nuxwdog.8.*
%_man8dir/pki-server-migrate.8.*
%_man8dir/pki-server-cert.8.*
%_man8dir/pki-server-ca.8.*
%_man8dir/pki-server-kra.8.*
%_man8dir/pki-server-ocsp.8.*
%_man8dir/pki-server-tks.8.*
%_man8dir/pki-server-tps.8.*

%_datadir/pki/setup/
%dir %_datadir/pki/server
%_datadir/pki/server/bin/
%_datadir/pki/server/common/
%_datadir/pki/server/conf/
%_datadir/pki/server/etc/
%_datadir/pki/server/lib/
%_datadir/pki/server/upgrade/
%_datadir/pki/server/certs/
%_datadir/pki/server/examples/
%_datadir/pki/server/database/

%files -n dogtag-pki-acme -f .mfiles-pki-acme
%_datadir/pki/acme/

%files -n dogtag-pki-ca -f .mfiles-pki-ca
%_datadir/pki/ca/

%files -n dogtag-pki-est -f .mfiles-pki-est
%_datadir/pki/est/

%files -n dogtag-pki-kra -f .mfiles-pki-kra
%_datadir/pki/kra/

%files -n dogtag-pki-ocsp -f .mfiles-pki-ocsp
%_datadir/pki/ocsp/

%files -n dogtag-pki-tks -f .mfiles-pki-tks
%_datadir/pki/tks/

%files -n dogtag-pki-tps -f .mfiles-pki-tps
%_datadir/pki/tps/
%_man5dir/pki-tps-connector.5.*
%_man5dir/pki-tps-profile.5.*

%if_with javadoc
%files -n dogtag-pki-javadoc
%_javadocdir/pki-%version/
%endif

%files -n dogtag-pki-healthcheck
%_sbindir/pki-healthcheck
%python3_sitelibdir/pki/server/healthcheck/
%python3_sitelibdir/pkihealthcheck-*.egg-info/
%config(noreplace) %_sysconfdir/pki/healthcheck.conf
%_man5dir/pki_healthcheck.conf.*
%_man8dir/pki-healthcheck.8.*

%files -n dogtag-pki-server-theme
%_datadir/pki/common-ui/
%_datadir/pki/CS_SERVER_VERSION
%dir %_datadir/pki/server
%dir %_datadir/pki/server/webapps
%dir %_datadir/pki/server/webapps/pki
%_datadir/pki/server/webapps/ROOT/
%_datadir/pki/server/webapps/pki/admin/
%_datadir/pki/server/webapps/pki/ca/
%_datadir/pki/server/webapps/pki/css/
%_datadir/pki/server/webapps/pki/esc/
%_datadir/pki/server/webapps/pki/fonts/
%_datadir/pki/server/webapps/pki/images/
%_datadir/pki/server/webapps/pki/js/
%_datadir/pki/server/webapps/pki/index.jsp
%_datadir/pki/server/webapps/pki/kra/
%_datadir/pki/server/webapps/pki/ocsp/
%_datadir/pki/server/webapps/pki/pki.properties/
%_datadir/pki/server/webapps/pki/tks/
%_datadir/pki/server/webapps/pki/ui/
%_datadir/pki/server/webapps/pki/WEB-INF/

%changelog
