%define _unpackaged_files_terminate_build 1

%global provider        github
%global provider_tld    com
%global project         docker
%global repo            docker
%global servicename     docker

%global import_path %{provider}.%{provider_tld}/%{project}/%{repo}
%global commit      710302ecf2e958db92cb7d92f8838ea063a31765
%global shortcommit %(c=%{commit}; echo ${c:0:7})

Name:    docker-engine
Version: 29.1.0
Release: alt1
Summary: The open-source application container engine
License: Apache-2.0
Group: System/Configuration/Other

Url: https://github.com/moby/moby
ExclusiveArch: %go_arches
ExcludeArch: %ix86
Conflicts: docker

Source0: %name-%version.tar
Source1: %servicename.service
Source2: %servicename.init
Source3: %servicename.sysconf
Source4: %servicename-storage.sysconf
Source5: daemon.json

BuildRequires(pre): rpm-build-golang
BuildRequires: /proc gcc golang >= 1.3 systemd-devel libdevmapper-devel libseccomp-devel libnftables-devel
Requires: tar xz
Provides: docker-io = %version-%release
Provides: docker-ce = %version-%release
Obsoletes: docker-io <= 17.05.0
Obsoletes: docker-io-devel <= 17.05.0
Obsoletes: docker-ce < 20.10.0
Requires: /usr/bin/docker-proxy
Requires: docker-containerd >= 1.0.2-alt1
Requires: docker-runc >= 1.0.0-alt4.rc5
Requires: docker-init >= 0.17.0-alt1
Requires: docker-cli >= 20.10.0-alt1.rc2
Requires: iptables

# do not extract debuginfo
%define __find_debuginfo_files %nil

%description
Docker Engine is an open source containerization technology for building and
containerizing your applications. Docker Engine acts as a client-server application with:

* A server with a long-running daemon process dockerd.
* APIs which specify interfaces that programs can use to talk to and instruct the Docker daemon.
* A command line interface (CLI) client docker

%package rootless
Summary: Use docker rootless
Group: System/Configuration/Other
Requires: rootlesskit %name slirp4netns

%description rootless
%summary

%package -n docker-proxy
Summary: docker-proxy util
Group: Development/Other

%description -n docker-proxy
This package provides docker-proxy util.

%prep
%setup
#%autopatch -p1

%build
# Temporary workaround to build with golang 1.16. Waiting for upstream to
# add go modules support.
#export GO111MODULE=off
export BUILDDIR="$PWD/.build"
export IMPORT_PATH="%import_path"
export GOPATH="%go_path:$BUILDDIR"

%golang_prepare

export DOCKER_GITCOMMIT=%{shortcommit}
export DOCKER_BUILDTAGS='selinux journald pkcs11 seccomp'
export VERSION=%{version}
hack/make.sh dynbinary

%install
# install binary
install -d %{buildroot}%{_bindir}
install -p -m 755 bundles/dynbinary-daemon/dockerd %{buildroot}%{_bindir}/dockerd
install -p -m 755 bundles/dynbinary-daemon/docker-proxy %{buildroot}%{_bindir}/docker-proxy

# install storage dir
install -d %{buildroot}%{_sharedstatedir}/%{servicename}

# install systemd/init scripts
install -p -D -m 644 altlinux/%{servicename}.service %{buildroot}%{_unitdir}/%{servicename}.service
install -p -m 644 contrib/init/systemd/docker.socket %{buildroot}%{_unitdir}/
install -p -D -m 755 altlinux/%{servicename}.init %{buildroot}%{_initddir}/%{servicename}

install -d %buildroot%_sysconfdir/sysconfig
install -p -m 644 altlinux/docker.sysconf %buildroot%_sysconfdir/sysconfig/docker
install -p -m 644 altlinux/docker-storage.sysconf %buildroot%_sysconfdir/sysconfig/docker-storage

install -d %buildroot%_sysconfdir/docker
install -p -m 644 altlinux/daemon.json %buildroot%_sysconfdir/docker/daemon.json

# install rootless scripts
install -p -D -m 755 contrib/dockerd-rootless-setuptool.sh %{buildroot}%{_bindir}/dockerd-rootless-setuptool.sh
install -p -D -m 755 contrib/dockerd-rootless.sh %{buildroot}%{_bindir}/dockerd-rootless.sh

%pre
getent group docker > /dev/null || %{_sbindir}/groupadd -r docker
exit 0

%post
%post_service docker

%preun
%preun_service docker

%files rootless
%_bindir/dockerd-rootless-setuptool.sh
%_bindir/dockerd-rootless.sh

%files -n docker-proxy
%_bindir/docker-proxy

%files
%doc AUTHORS LICENSE
%doc MAINTAINERS NOTICE
%doc CONTRIBUTING.md README.md
%config(noreplace) %{_sysconfdir}/sysconfig/docker
%config(noreplace) %{_sysconfdir}/sysconfig/docker-storage
%config(noreplace) %{_sysconfdir}/docker/daemon.json
%{_bindir}/dockerd
%{_unitdir}/docker.service
%{_unitdir}/docker.socket
%_initdir/docker
%dir %{_sharedstatedir}/docker

%changelog
