%global import_path github.com/dmachard/dns-collector
Name:    dns-collector
Version: 1.13.0
Release: alt1

Summary: Ingesting, pipelining, and enhancing your DNS logs with usage indicators, security analysis, and additional metadata
License: MIT
Group:   Other
Url:     https://github.com/dmachard/DNS-collector

Packager: Andrey Cherepanov <cas@altlinux.org>

Source: %name-%version.tar
Source1: vendor.tar
Source2: dnscollector.service
Source3: config.yml

BuildRequires(pre): rpm-build-golang
BuildRequires: golang

%description
DNS-collector acts as a passive high speed ingestor with pipelining support for
your DNS logs, written in Golang. It allows enhancing your DNS logs by adding
metadata, extracting usage patterns, and facilitating security analysis.

Additionally, DNS-collector also supports:
- Extended DNStap with TLS encryption, compression, and more metadata
  capabilities DNS protocol conversions to Plain text, Key/Value JSON, Jinja
  and more
- DNS parser with Extension Mechanisms for DNS (EDNS) support
- Live capture on a network interface
- IPv4/v6 defragmentation and TCP reassembly
- Nanoseconds in timestamps

%prep
%setup
tar xf %SOURCE1

%build
export BUILDDIR="$PWD/.build"
export IMPORT_PATH="%import_path"
export GOPATH="$BUILDDIR:%go_path"

%golang_prepare
export LDFLAGS="-X github.com/prometheus/common/version.Version=%version"
cd .build/src/%import_path
%golang_build .

%install
export BUILDDIR="$PWD/.build"
export IGNORE_SOURCES=1

%golang_install
install -Dpm0644 %SOURCE2 %buildroot%_unitdir/dnscollector.service
install -Dpm0644 %SOURCE3 %buildroot%_sysconfdir/dnscollector/config.yml
mkdir -p %buildroot%_runtimedir/dnscollector
mkdir -p %buildroot%_logdir/dnscollector
mkdir -p %buildroot%_localstatedir/dnscollector

%pre
%_sbindir/useradd -c 'Go DnsCollector' -d %_runtimedir/dnscollector \
    -s /sbin/nologin -r dnscollector 2>/dev/null ||:
# Create SSL key
test -x /var/lib/ssl/certs/dnscollector.cert || /usr/bin/cert-sh generate "dnscollector" &>/dev/null

%preun
%preun_service dnscollector

%post
if [ ! -x %_localstatedir/dnscollector/dnscollector.key ]; then
	cp -a /var/lib/ssl/private/dnscollector.key %_localstatedir/dnscollector/dnscollector.key &>/dev/null
	chown dnscollector %_localstatedir/dnscollector/dnscollector.key &>/dev/null
fi
%post_service dnscollector

%files
%doc *.md
%_bindir/*
%config(noreplace) %_sysconfdir/dnscollector/config.yml
%_unitdir/dnscollector.service
%attr(0700,dnscollector,dnscollector) %_runtimedir/dnscollector
%attr(0700,dnscollector,dnscollector) %_logdir/dnscollector
%attr(0700,dnscollector,dnscollector) %_localstatedir/dnscollector

%changelog
