%define _libexecdir %_prefix/libexec
%define twver 0

Name: deepin-terminal
Version: 6.5.20
Release: alt1

Summary: Default terminal emulation application for Deepin

License: GPL-3.0+ and (LGPL-2.0+ and GPL-2.0+ and BSD-3-Clause)
Group: Terminals
Url: https://github.com/linuxdeepin/deepin-terminal
Vcs: https://github.com/linuxdeepin/deepin-terminal

# Source-url: %url/archive/%version/%name-%version.tar.gz
Source: %name-%version.tar
Patch: %name-%version-%release.patch

Requires: deepin-shortcut-viewer expect xdg-utils
Requires: icon-theme-hicolor
Requires: %name-data
Requires: terminalwidget5-data
Requires: libdqt5-widgets = %_dqt5_version
#Recommends:     deepin-manual
#Recommends:     zssh

BuildRequires(pre): rpm-build-ninja rpm-macros-dqt5 patchelf rpm-macros-cmake
BuildRequires: cmake dtk6-common-devel libdtkwidget-devel libsecret-devel libxcbutil-icccm-devel lxqt-build-tools dqt5-tools-devel dqt5-x11extras-devel libchardet-devel libuchardet-devel libwayland-client-devel

%description
%summary.

%package data
Summary: Data files of Deepin Terminal
Group: Terminals
BuildArch: noarch
Requires: icon-theme-hicolor

%description data
The %name-data package provides shared data for Deepin Terminal.

%package -n libterminalwidget5
Summary: Qt5 terminal widget
Group: System/Libraries

%description -n libterminalwidget5
QTermWidget is an opensource project based on KDE4 Konsole application.

The main goal of this project is to provide unicode-enabled,
embeddable QT5 widget for using as a built-in console or terminal emulation widget.

%package -n terminalwidget5-data
Summary: Data files of QTermWidget
Group: Other
BuildArch: noarch

%description -n terminalwidget5-data
The terminalwidget5-data package provides shared data for QTermWidget.

%package -n libterminalwidget5-devel
Summary: Qt5 terminal widget - development package
Group: Development/KDE and QT

%description -n libterminalwidget5-devel
Development package for QTermWidget. Contains headers and dev-libs.

%prep
%setup
%patch -p1

%build
export CMAKE_PREFIX_PATH=%_dqt5_libdir/cmake:$CMAKE_PREFIX_PATH
export PKG_CONFIG_PATH=%_dqt5_libdir/pkgconfig:$PKG_CONFIG_PATH
export PATH=%_dqt5_bindir:$PATH
%cmake \
    -GNinja \
    -DDTKCORE_TOOL_DIR=%_libexecdir/dtk5/DCore/bin \
    -DCMAKE_BUILD_TYPE=Release \
    -DTERM_RPATH=OFF \
    -DCMAKE_SKIP_RPATH=NO \
    -DCMAKE_SKIP_INSTALL_RPATH=NO \
    -DCMAKE_INSTALL_RPATH=%_dqt5_libdir \
    -DCMAKE_INSTALL_LIBDIR=%_libdir \
    -DCMAKE_INSTALL_PREFIX=%_prefix \
    -DVERSION=%version
cmake --build "%_cmake__builddir" -j%__nprocs
# remove broken build rpath from elfs
patchelf %_host_alias/%name --shrink-rpath --allowed-rpath-prefixes %_dqt5_libdir
# find requires for pc file
sed -i -e '/Libs/s|terminalwidget5|terminalwidget5 -L%_dqt5_libdir -lQt5Widgets|; s|Requires:.*|Requires:|;' \
  %_host_alias/3rdparty/terminalwidget/terminalwidget5.pc

%install
%cmake_install
%find_lang --with-qt %name
%find_lang --with-qt terminalwidget5

%files
%doc README.md
%doc LICENSE
%doc debian/changelog
%_bindir/%name

%files data -f %name.lang
%_iconsdir/hicolor/*/apps/%{name}*
%_desktopdir/%name.desktop
%dir %_datadir/deepin-manual/
%dir %_datadir/deepin-manual/manual-assets/
%dir %_datadir/deepin-manual/manual-assets/application/
%dir %_datadir/deepin-manual/manual-assets/application/%name/
%_datadir/deepin-manual/manual-assets/application/%name/terminal/
%dir %_datadir/deepin-debug-config/
%dir %_datadir/deepin-debug-config/deepin-debug-config.d/
%_datadir/deepin-debug-config/deepin-debug-config.d/org.deepin.terminal.json
%dir %_datadir/deepin-log-viewer/
%dir %_datadir/deepin-log-viewer/deepin-log.conf.d/
%_datadir/deepin-log-viewer/deepin-log.conf.d/org.deepin.terminal.json
%dir %_datadir/dsg/
%dir %_datadir/dsg/configs/
%dir %_datadir/dsg/configs/org.deepin.terminal/
%_datadir/dsg/configs/org.deepin.terminal/org.deepin.terminal.json
# outside %%find_lang
%dir %_datadir/%name/
%dir %_datadir/%name/translations/
%_datadir/%name/translations/%name.qm

%files -n libterminalwidget5
%_libdir/libterminalwidget5.so.%{twver}*

%files -n terminalwidget5-data -f terminalwidget5.lang
%doc 3rdparty/terminalwidget/{AUTHORS,LICENSE*,CHANGELOG}
%dir %_datadir/terminalwidget5/
%dir %_datadir/terminalwidget5/translations/
%_datadir/terminalwidget5/kb-layouts/
%_datadir/terminalwidget5/color-schemes/

%files -n libterminalwidget5-devel
%_libdir/libterminalwidget5.so
%_pkgconfigdir/terminalwidget5.pc
%_libdir/cmake/terminalwidget5/
%_includedir/terminalwidget5/

%changelog
