%define _libexecdir %_prefix/lib
%define _unitdir %_prefix/lib/systemd/system

%def_disable clang

Name: deepin-system-monitor
Version: 6.5.36
Release: alt1

Summary: A more user-friendly system monitor

License: GPL-3.0+
Group: Monitoring
Url: https://github.com/linuxdeepin/deepin-system-monitor
Vcs: https://github.com/linuxdeepin/deepin-system-monitor

# Source-url: %url/archive/%version/%name-%version.tar.gz
Source: %name-%version.tar
Patch0: %name-%version-%release.patch
Patch1: deepin-system-monitor-6.5.8-alt-fix-GNUInstallDirs.patch
Patch2: deepin-system-monitor-6.0.12-alt-fix-build-gcc13.patch
Patch3: deepin-system-monitor-6.0.12-alt-fix-build-ppc64le.patch

BuildRequires(pre): rpm-build-ninja rpm-build-xdg desktop-file-utils rpm-macros-dqt6
# Automatically added by buildreq on Thu Mar 13 2025
# optimized out: cmake cmake-modules dqt6-base-devel dqt6-tools gcc-c++ glibc-kernheaders-generic glibc-kernheaders-x86 icu-utils libdouble-conversion3 libdqt6-concurrent libdqt6-core libdqt6-dbus libdqt6-gui libdqt6-network libdqt6-printsupport libdqt6-svg libdqt6-waylandclient libdqt6-widgets libdqt6-xml libdtk6core-devel libdtk6gui-devel libdtk6log-devel libglvnd-devel libgpg-error libicu-devel libp11-kit libpolkit-qt6-agent libpolkit-qt6-core libpolkit-qt6-gui libsasl2-3 libssl-devel libstartup-notification libstdc++-devel libwayland-client libwayland-cursor libxcb-devel libxcbutil-icccm libxkbcommon-devel ninja-build perl perl-Config-Tiny perl-Encode perl-XML-LibXML perl-parent pkg-config python3 python3-base sh5 vulkan-headers
BuildRequires: dde-dock-devel deepin-gettext-tools dqt6-svg-devel dqt6-tools-devel dtk6-common-devel libXext-devel libcups-devel libdtk6widget-devel libnl-devel libpcap-devel libpolkitqt6-qt6-devel libudev-devel libxcbutil-icccm-devel

%if_enabled clang
BuildRequires: clang-devel
BuildRequires: lld-devel
%else
BuildRequires: gcc-c++
%endif

%description
%summary.

%prep
%setup
%autopatch -p1

%build
# fix gcc14
# https://github.com/linuxdeepin/developer-center/issues/10558
%add_optflags -Wno-error=incompatible-pointer-types
%if_enabled clang
%define optflags_lto -flto=thin
export CC=clang
export CXX=clang++
export LDFLAGS="-fuse-ld=lld $LDFLAGS"
%endif
export CPLUS_INCLUDE_PATH=%_includedir/qt6:$CPLUS_INCLUDE_PATH
%DQ6build \
    -DLIB_DESTINATION=%_lib \
    -DLIB_INSTALL_DIR=%_libdir \
    -DCMAKE_INSTALL_SYSCONFDIR=%_sysconfdir \
    -DUSE_DEEPIN_WAYLAND=ON \
    -DVERSION=%version

%install
%DQ6install
%find_lang --with-qt --output=%name.lang %name %{name}-plugin %{name}-plugin-popup

%check
desktop-file-validate %buildroot%_desktopdir/%name.desktop ||:

%files -f %name.lang
%doc README.md
%doc LICENSE
%doc debian/changelog
%_bindir/%name
%_bindir/%name-server
%_bindir/%name-plugin-popup
%_datadir/polkit-1/actions/com.deepin.pkexec.deepin-system-monitor.policy
%_datadir/polkit-1/actions/org.deepin.deepin-system-monitor-system-server.policy
%_desktopdir/%name.desktop
%dir %_libdir/dde-dock/
%dir %_libdir/dde-dock/plugins/
%_libdir/dde-dock/plugins/libdeepin-system-monitor-plugin.so
%dir %_datadir/dde-dock/
%dir %_datadir/dde-dock/icons/
%dir %_datadir/dde-dock/icons/dcc-setting/
%_datadir/dde-dock/icons/dcc-setting/dcc-system-monitor.dci
%dir %_libdir/deepin-service-manager/
%_libdir/deepin-service-manager/libdeepin-system-monitor-daemon.so
%_datadir/dbus-1/services/com.deepin.SystemMonitorPluginPopup.service
%_datadir/dbus-1/services/com.deepin.SystemMonitorServer.service
%_datadir/dbus-1/system-services/org.deepin.SystemMonitorSystemServer.service
%_datadir/dbus-1/system.d/org.deepin.SystemMonitorSystemServer.conf
# package translations outside %%find_lang
%dir %_datadir/%name/
%dir %_datadir/%name/translations/
%_datadir/%name/translations/%name.qm
%dir %_datadir/%name-plugin/
%dir %_datadir/%name-plugin/translations/
%_datadir/%name-plugin/translations/%name-plugin.qm
%dir %_datadir/%name-plugin-popup/
%dir %_datadir/%name-plugin-popup/translations/
# ---
%_datadir/glib-2.0/schemas/com.deepin.dde.dock.module.system-monitor.gschema.xml
%dir %_datadir/deepin-service-manager/
%dir %_datadir/deepin-service-manager/user/
%_datadir/deepin-service-manager/user/deepin-system-monitor-daemon.json
%dir %_datadir/deepin-service-manager/other/
%_datadir/deepin-service-manager/other/deepin-system-monitor-system-server.json
%dir %_datadir/dsg/
%dir %_datadir/dsg/configs/
%dir %_datadir/dsg/configs/org.deepin.system-monitor/
%_datadir/dsg/configs/org.deepin.system-monitor/org.deepin.system-monitor.main.json
%_datadir/dsg/configs/org.deepin.system-monitor/org.deepin.system-monitor.daemon.json
%_datadir/dsg/configs/org.deepin.system-monitor/org.deepin.system-monitor.json
%_datadir/dsg/configs/org.deepin.system-monitor/org.deepin.system-monitor.plugin.json
%_datadir/dsg/configs/org.deepin.system-monitor/org.deepin.system-monitor.plugin.popup.json
%_datadir/dsg/configs/org.deepin.system-monitor/org.deepin.system-monitor.server.json
%dir %_datadir/deepin-manual/
%dir %_datadir/deepin-manual/manual-assets/
%dir %_datadir/deepin-manual/manual-assets/application/
%dir %_datadir/deepin-manual/manual-assets/application/%name/
%_datadir/deepin-manual/manual-assets/application/%name/system-monitor/
%dir %_libexecdir/deepin-daemon/
%_libexecdir/deepin-daemon/deepin-system-monitor-system-server
%_unitdir/deepin-system-monitor-system-server.service
%dir %_datadir/deepin-log-viewer/
%dir %_datadir/deepin-log-viewer/deepin-log.conf.d/
%_datadir/deepin-log-viewer/deepin-log.conf.d/org.deepin.system-monitor.json

%changelog
