%def_without clang

%define repo dde-session-ui

Name: deepin-session-ui
Version: 6.0.34
Release: alt1

Summary: Deepin desktop-environment - Session UI module

License: GPL-3.0-or-later
Group: Graphical desktop/Other
Url: https://github.com/linuxdeepin/dde-session-ui
Vcs: https://github.com/linuxdeepin/dde-session-ui

Packager: Leontiy Volodin <lvol@altlinux.org>

# Source-url: https://github.com/linuxdeepin/dde-session-ui/archive/%version/%repo-%version.tar.gz
Source: %repo-%version.tar
Patch: %name-%version-%release.patch

# %%_datadir/dbus-1/services/org.freedesktop.Notifications.service
Conflicts: notify-osd

BuildRequires(pre): rpm-build-ninja rpm-macros-dqt6 rpm-macros-systemd
BuildRequires: dqt6-sql-interbase dqt6-sql-mysql dqt6-sql-odbc dqt6-sql-postgresql dqt6-svg-devel dqt6-tools-devel dtk6-common-devel libXext-devel libdeepin-pw-check-devel libdtk6widget-devel libgio-devel libgtest-devel libsystemd-devel libxcbutil-icccm-devel
%if_with clang
BuildRequires: clang-devel
%else
BuildRequires: gcc-c++
%endif

%description
This project include those sub-project:
- dde-switchtogreeter: The tools to switch the user to login in.
- dde-license-dialog.
- dde-pixmix.
- dde-wm-chooser.
- dmemory-warning-dialog.

%prep
%setup -n %repo-%version
%autopatch -p1
#sed -i 's|default_background.jpg|deepin/desktop.jpg|' \
#    widgets/fullscreenbackground.cpp \
#    lightdm-deepin-greeter/logintheme.qrc \
#    dde-lock/logintheme.qrc

%build
export LC_ALL=C.UTF-8
%if_with clang
export CC="clang"
export CXX="clang++"
export AR="llvm-ar"
export NM="llvm-nm"
export READELF="llvm-readelf"
%endif
%DQ6build \
%ifarch aarch64 armh ppc64le
    -DSHUTDOWN_NO_QUIT=YES \
    -DLOCK_NO_QUIT=YES \
    -DDISABLE_DEMO_VIDEO=YES \
    -DDISABLE_TEXT_SHADOW=YES \
    -DDISABLE_ANIMATIONS=YES \
    -DUSE_CURSOR_LOADING_ANI=YES \
    -DSYSTEMD_USER_UNIT_DIR=%_userunitdir \
%endif
#

%install
%DQ6install
%find_lang --with-qt %repo

%files -f %repo.lang
%doc README.md
%doc LICENSE
%doc debian/changelog
%_bindir/dde-license-dialog
%_bindir/dde-pixmix
%_bindir/dde-switchtogreeter
%_bindir/dde-wm-chooser
%_bindir/dde-hints-dialog
%dir %_libexecdir/deepin-daemon/
%_libexecdir/deepin-daemon/dde-bluetooth-dialog
%_libexecdir/deepin-daemon/dde-lowpower
%_libexecdir/deepin-daemon/dde-blackwidget
%_libexecdir/deepin-daemon/dde-suspend-dialog
%_libexecdir/deepin-daemon/dde-warning-dialog
%_libexecdir/deepin-daemon/dde-touchscreen-dialog
%_libexecdir/deepin-daemon/dde-welcome
%_libexecdir/deepin-daemon/dnetwork-secret-dialog
%dir %_libexecdir/dde-control-center/
%_libexecdir/dde-control-center/reset-password-dialog
%_userunitdir/dde-blackwidget.service
%_iconsdir/hicolor/scalable/devices/computer.svg
%_datadir/dbus-1/services/*.service
# outside %%find_lang
%dir %_datadir/%repo/
%dir %_datadir/%repo/translations/
%_datadir/%repo/translations/dde-session-ui_ky@Arab.qm

%changelog
