%def_without clang

%define repo dde-session-shell

Name: deepin-session-shell
Version: 6.0.51
Release: alt1
Epoch: 1

Summary: Deepin desktop-environment - Session shell module

License: GPL-3.0+
Group: Graphical desktop/Other
Url: https://github.com/linuxdeepin/dde-session-shell
VCS: https://github.com/linuxdeepin/dde-session-shell

# Source-url: https://github.com/linuxdeepin/dde-session-shell/archive/%version/%repo-%version.tar.gz
Source: %repo-%version.tar
Patch: %name-%version-%release.patch

# Requires: chkpwd-pam

BuildRequires(pre): deepin-gettext-tools
BuildRequires: cmake dqt6-svg-devel dqt6-tools-devel dtk6-common-devel libXcursor-devel libXrandr-devel libXtst-devel libcups-devel libdtk6widget-devel libgtest-devel libpam-devel libxcbutil-icccm-devel dde-lightdm-devel
%if_with clang
BuildRequires: clang-devel lld-devel
%else
BuildRequires: gcc-c++
%endif

%description
%summary.

%package devel
Summary: %summary
Group: Development/Other

%description devel
%summary.

%package -n lightdm-deepin-greeter-enable
Summary: Enable config for own lightdm theme
Group: System/Configuration/Other
BuildArch: noarch
Requires: deepin-session-shell

%description -n lightdm-deepin-greeter-enable
The package provides the configuration file
for enabling the deepin theme for lightdm.

%prep
%setup -n %repo-%version
%autopatch -p1
# sed -i '/kwin_wayland/s|/usr/bin/||' \
#     files/wayland/kwin_wayland_helper-wayland \
#     files/wayland/launch-kwin-wayland
sed -i 's|/usr/lib/x86_64-linux-gnu/qt5|%_libdir/dqt6|' \
    files/wayland/lightdm-deepin-greeter-wayland \
    files/wayland/launch-kwin-wayland
sed -i '/QT_QPA_PLATFORM_PLUGIN_PATH/s|/usr/plugins/platforms|%_libdir/dqt6/plugins/platforms|' \
    files/wayland/lightdm-deepin-greeter-wayland
sed -i 's|/usr/lib/|%_libdir/|g' \
    src/global_util/plugin_manager/modules_loader.cpp
sed -i '/execute_process/s|/usr/lib/qt${QT_VERSION_MAJOR}/bin|%_dqt6_bindir|' \
    CMakeLists.txt
sed -i '/LIBRARY DESTINATION/s|lib/|${LIB_DESTINATION}/|' \
    $(find ./plugins -name CMakeLists.txt)

%build
%if_with clang
export CC="clang"
export CXX="clang++"
export LDFLAGS="-fuse-ld=lld $LDFLAGS"
%endif
%DQ6build \
  -DCMAKE_INSTALL_SYSCONFDIR=%_sysconfdir \
  -DLIB_DESTINATION=%_lib \
  -DCMAKE_EXE_LINKER_FLAGS='-L%_dqt6_libdir -L%_libdir' \
#

%install
%DQ6install
%find_lang --with-qt %repo

%files -f %repo.lang
%doc LICENSE README.md
%dir %_sysconfdir/deepin/
%dir %_sysconfdir/deepin/greeters.d/
%config(noreplace) %_sysconfdir/deepin/greeters.d/00-xrandr
%config(noreplace) %_sysconfdir/deepin/greeters.d/lightdm-deepin-greeter
%config(noreplace) %_sysconfdir/deepin/greeters.d/10-cursor-theme
%dir %_sysconfdir/lightdm/deepin/
%config(noreplace) %_sysconfdir/lightdm/deepin/qt-theme.ini
%config(noreplace) %_sysconfdir/pam.d/dde-lock
%config(noreplace) %_sysconfdir/pam.d/deepin-lightdm-autologin
%_bindir/deepin-greeter
%_bindir/lightdm-deepin-greeter
%_bindir/dde-lock
%dir %_datadir/dde-session-shell/
%_datadir/dde-session-shell/dde-session-shell.conf
%dir %_datadir/dde-session-shell/greeters.d/
%_datadir/dde-session-shell/greeters.d/pre-greeter
%dir %_datadir/dde-session-shell/translations/
%_datadir/dde-session-shell/translations/dde-session-shell.qm
%_datadir/dde-session-shell/translations/dde-session-shell_ky@Arab.qm
%_desktopdir/dde-lock.desktop
%_datadir/dbus-1/services/*.service
%_datadir/xgreeters/lightdm-deepin-greeter.desktop
%dir %_datadir/deepin-authentication/
%dir %_datadir/deepin-authentication/privileges/
%_datadir/deepin-authentication/privileges/lightdm-deepin-greeter.conf
%_libdir/security/pam_inhibit_autologin.so
%dir %_datadir/dsg/
%dir %_datadir/dsg/configs/
%dir %_datadir/dsg/configs/org.deepin.dde.lightdm-deepin-greeter/
%_datadir/dsg/configs/org.deepin.dde.lightdm-deepin-greeter/org.deepin.dde.lightdm-deepin-greeter.json
%dir %_datadir/dsg/configs/org.deepin.dde.lock/
%_datadir/dsg/configs/org.deepin.dde.lock/org.deepin.dde.lock.json
%dir %_datadir/dsg/configs/org.deepin.dde.session-shell/
%_datadir/dsg/configs/org.deepin.dde.session-shell/org.deepin.dde.session-shell.json
%dir %_datadir/deepin-debug-config/
%dir %_datadir/deepin-debug-config/deepin-debug-config.d/
%_datadir/deepin-debug-config/deepin-debug-config.d/org.deepin.dde.session-shell.json
%dir %_datadir/deepin-log-viewer/
%dir %_datadir/deepin-log-viewer/deepin-log.conf.d/
%_datadir/deepin-log-viewer/deepin-log.conf.d/org.deepin.dde.session-shell.json

%files -n lightdm-deepin-greeter-enable
%_datadir/lightdm/lightdm.conf.d/50-deepin.conf

%files devel
%dir %_includedir/dde-session-shell/
%_includedir/dde-session-shell/*.h
%dir %_libdir/cmake/DdeSessionShell/
%_libdir/cmake/DdeSessionShell/DdeSessionShellConfig.cmake

%changelog
