%define repo dde-polkit-agent

%def_disable clang

Name: deepin-polkit-agent
Version: 6.0.16
Release: alt1

Summary: Deepin Polkit Agent

License: GPL-3.0+
Group: Graphical desktop/Other
Url: https://github.com/linuxdeepin/dde-polkit-agent
Vcs: https://github.com/linuxdeepin/dde-polkit-agent

# Source-url: %url/archive/%version/%repo-%version.tar.gz
Source: %repo-%version.tar
Patch: %name-%version-%release.patch

%if_enabled clang
BuildRequires(pre): clang-devel
%else
BuildRequires(pre): gcc-c++
%endif
BuildRequires(pre): rpm-build-ninja rpm-macros-dqt6
BuildRequires: cmake libdtk6widget-devel dtk6-common-devel dqt6-tools-devel dqt6-declarative-devel libdde-shell-devel deepin-shell libpolkitqt6-dqt6-devel libcups-devel

%description
DDE Polkit Agent is the polkit agent used in Deepin Desktop Environment.

%package devel
Summary: Development package for %name
Group: Graphical desktop/Other
BuildArch: noarch

%description devel
Header files and libraries for %name.

%prep
%setup -n %repo-%version
%autopatch -p1
# find special polkitqt6
sed \
  -e '/Polkit-qt6_LIBRARIES/i \
  %_dqt6_libdir/libpolkit-qt6-agent-1.so.1 \
  %_dqt6_libdir/libpolkit-qt6-core-1.so.1 \
  %_dqt6_libdir/libpolkit-qt6-gui-1.so.1' \
  -e '/Polkit-qt6_LIBRARIES/d' \
  -i CMakeLists.txt

%build
export CPLUS_INCLUDE_PATH=%_dqt6_headerdir/polkit-qt6-1/:$CPLUS_INCLUDE_PATH
export LC_ALL="C.UTF-8"
%if_enabled clang
export CC="clang"
export CXX="clang++"
export AR="llvm-ar"
export NM="llvm-nm"
export READELF="llvm-readelf"
%endif
%DQ6build

%install
%DQ6install
%find_lang --with-qt %repo

%files -f %repo.lang
%doc README.md
%doc LICENSE
%doc debian/changelog
%dir %_libexecdir/polkit-1-dde
%_libexecdir/polkit-1-dde/%repo
# package outside find_lang
%dir %_datadir/%repo/
%dir %_datadir/%repo/translations/
%_datadir/%repo/translations/%repo.qm

%files devel
%dir %_includedir/dpa/
%_includedir/dpa/agent-extension-proxy.h
%_includedir/dpa/agent-extension.h

%changelog
