Name: deepin-picker
Version: 6.0.11
Release: alt1

Summary: Color picker tool for deepin

License: GPL-3.0+
Group: Graphics
Url: https://github.com/linuxdeepin/deepin-picker
VCS: https://github.com/linuxdeepin/deepin-picker

Packager: Leontiy Volodin <lvol@altlinux.org>

# Source-url: https://github.com/linuxdeepin/deepin-picker/archive/%version/%name-%version.tar.gz
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): desktop-file-utils
BuildRequires: dqt6-linguist libdtk6widget-devel libX11-devel libxcb-devel libxcbutil-devel libXext-devel libXtst-devel dqt6-base-devel dqt6-svg-devel

Requires: icon-theme-hicolor

%description
Simplest color picker.

%prep
%setup
%patch -p1
sed -i -e 's|/usr/lib/qt6/bin/lrelease|%_dqt6_bindir/lrelease|; s|/usr/lib/qt6/bin/lupdate|%_dqt6_bindir/lupdate|;' \
	deepin-picker.pro

%build
export PATH=%_dqt6_bindir:$PATH
export LC_ALL=C.UTF-8
%qmake_dqt6 \
  CONFIG+=nostrip \
  PREFIX=%_prefix \
  QMAKE_RPATHDIR=%_dqt6_libdir \
#
%make_build

%install
export LC_ALL=C.UTF-8
%makeinstall INSTALL_ROOT=%buildroot
%find_lang --with-qt %name

%files -f %name.lang
%doc README.md
%doc LICENSE.txt
%doc debian/changelog
%_bindir/%name
%_desktopdir/%name.desktop
%_iconsdir/hicolor/scalable/apps/%name.svg
%_datadir/dbus-1/services/com.deepin.Picker.service
# package translations outside find_lang
%dir %_datadir/%name/
%dir %_datadir/%name/translations/
%_datadir/%name/translations/deepin-picker.qm
%_datadir/%name/translations/deepin-picker_es_419.qm

%changelog
