%define repo image-editor
%define repoiv imageviewer6
%define repoivr imagevisualresult6
%define sonameiv 0.1
%define sonameivr 0.1

%def_without clang

Name: deepin-image-editor
Version: 6.5.2
Release: alt1

Summary: Image editor libraries for Deepin

License: GPL-3.0+
Group: System/Libraries
Url: https://github.com/linuxdeepin/image-editor
VCS: https://github.com/linuxdeepin/image-editor

Packager: Leontiy Volodin <lvol@altlinux.org>

# Source-url: https://github.com/linuxdeepin/image-editor/archive/%version/%repo-%version.tar.gz
Source: %repo-%version.tar
Patch0: %name-%version-%release.patch
Patch1: deepin-image-editor-6.5.0-alt-fix-broken-pkgconfig.patch
Patch2: deepin-image-editor-6.5.0-alt-fix-dqt6-pkgconfig.patch
Patch3: deepin-image-editor-6.5.0-alt-cmake-compat.patch
Patch4: deepin-image-editor-6.5.0-alt-fix-qt6-cmake.patch
Patch5: deepin-image-editor-6.5.0-alt-fix-underlinked-libraries.patch

%if_with clang
ExcludeArch: armh
%endif

BuildRequires: cmake glib2-devel dtk6-common-devel libdtk6widget-devel libffmpegthumbnailer-devel libfreeimage-devel libmediainfo-devel libtiff-devel dqt6-svg-devel dqt6-tools-devel libdfm6-io-devel libcups-devel

%if_with clang
BuildRequires: clang-devel
%else
BuildRequires: gcc-c++
%endif

%description
Image editor is a public library for deepin-image-viewer
and deepin-album developed by Deepin Technology.

%package -n lib%repoiv-data
Summary: Data files for lib%repoiv
Group: Development/Other
BuildArch: noarch

%description -n lib%repoiv-data
Data files for libimageviewer.

%package -n lib%repoivr-data
Summary: Data files for lib%repoivr
Group: Development/Other
BuildArch: noarch

%description -n lib%repoivr-data
Data files for libimagevisualresult.

%package -n lib%{repoiv}_%sonameiv
Summary: Image editor library for deepin-image-viewer
Group: System/Libraries
Requires: lib%repoiv-data

%description -n lib%{repoiv}_%sonameiv
Image editor is a public library for deepin-image-viewer
by Deepin Technology.

%package -n lib%repoiv-devel
Summary: Development package for deepin-image-viewer
Group: Development/C++

%description -n lib%repoiv-devel
Development libraries for deepin-image-viewer.

%package -n lib%{repoivr}_%sonameivr
Summary: Image editor library for deepin-album
Group: System/Libraries

%description -n lib%{repoivr}_%sonameivr
Image editor is a public library for deepin-image-viewer
by Deepin Technology.

%package -n lib%repoivr-devel
Summary: Development package for deepin-album
Group: Development/C++

%description -n lib%repoivr-devel
Development libraries for deepin-album.

%prep
%setup -n %repo-%version
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p2
%patch5 -p2

%build
%if_with clang
%define optflags_lto -flto=thin
export CC=clang
export CXX=clang++
export LDFLAGS="-fuse-ld=lld $LDFLAGS"
%else
%define optflags_lto %nil
%endif
%DQ6build \
  -DCMAKE_INSTALL_LIBDIR=%_lib \
#

%install
%DQ6install
%find_lang --with-qt lib%repoiv

%files -n lib%repoiv-data -f lib%repoiv.lang
%doc LICENSE.txt README.md
%dir %_datadir/lib%repoiv/
%dir %_datadir/lib%repoiv/translations/
%_datadir/lib%repoiv/translations/libimageviewer.qm

%files -n lib%repoivr-data
%dir %_datadir/lib%repoivr/
%_datadir/lib%repoivr/filter*

%files -n lib%{repoiv}_%sonameiv
%_libdir/lib%repoiv.so.%{sonameiv}*

%files -n lib%repoiv-devel
%_libdir/lib%repoiv.so
%_includedir/lib%repoiv/
%_pkgconfigdir/lib%repoiv.pc

%files -n lib%{repoivr}_%sonameivr
%_libdir/lib%repoivr.so.%{sonameivr}*

%files -n lib%repoivr-devel
%_libdir/lib%repoivr.so
%_includedir/lib%repoivr/
%_pkgconfigdir/lib%repoivr.pc

%changelog
