%def_disable clang

Name: deepin-editor
Version: 6.5.40
Release: alt1

Summary: Simple editor for Linux Deepin

License: GPL-3.0+
Group: Editors
Url: https://github.com/linuxdeepin/deepin-editor
VCS: https://github.com/linuxdeepin/deepin-editor

# Source-url: %url/archive/%version/%name-%version.tar.gz
Source: %name-%version.tar
Patch0: deepin-editor-%version-%release.patch
Patch1: deepin-editor-6.0.16-armh-ppc64le.patch

BuildRequires(pre): rpm-build-ninja rpm-macros-dqt6
# Automatically added by buildreq on Wed Apr 09 2025
# optimized out: at-spi2-atk cmake cmake-modules dqt6-base-common dqt6-base-devel gcc-c++ glibc-kernheaders-generic glibc-kernheaders-x86 icon-naming-utils icu-utils libEGL-mesa libGLX-mesa libX11-devel libat-spi2-core libcairo-gobject libcap-ng libclang-cpp19 libcrypt-devel libctf-nobfd0 libdouble-conversion3 libdqt6-concurrent libdqt6-core libdqt6-core5compat libdqt6-dbus libdqt6-gui libdqt6-network libdqt6-printsupport libdqt6-svg libdqt6-waylandclient libdqt6-widgets libdqt6-xml libdtk6core-devel libdtk6gui-devel libdtk6log-devel libgdk-pixbuf libglvnd-devel libgpg-error libjson-glib libp11-kit libqt6-core libqt6-dbus libqt6-eglfsdeviceintegration libqt6-eglfskmssupport libqt6-gui libqt6-network libqt6-opengl libqt6-qml libqt6-qmlmeta libqt6-qmlmodels libqt6-qmlworkerscript libqt6-quick libsasl2-3 libspirv-tools0 libssl-devel libstartup-notification libstdc++-devel libwayland-client libwayland-cursor libwayland-egl libwayland-server libxcb-devel libxcb-render-util libxcbutil-cursor libxcbutil-icccm libxcbutil-image libxcbutil-keysyms libxkbcommon-devel libxkbcommon-x11 llvm19.1-libs ninja-build pam0_userpass perl pkg-config python3 python3-base sh5 vulkan-headers
BuildRequires: deepin-qt-dbus-factory-devel dqt6-5compat-devel dqt6-svg-devel dqt6-tools dtk6-common-devel kf6-kcodecs-devel kf6-syntax-highlighting-devel libchardet-devel libcups-devel libdtk6widget-devel libicu-devel libuchardet-devel
%if_enabled clang
BuildRequires: clang-devel
BuildRequires: lld-devel
BuildRequires: libstdc++-devel
%else
BuildRequires: gcc-c++
%endif

# Requires: deepin-session-shell deepin-dqt5integration

%description
%summary.

%prep
%setup
%patch0 -p1
%patch1 -p1
sed -i 's|/lib/qt${QT_VERSION_MAJOR}/bin/lrelease|%_dqt6_bindir/lrelease|' \
  cmake/translation-generate.cmake

%build
%if_enabled clang
%define optflags_lto -flto=thin
export CC=clang
export CXX=clang++
export LDFLAGS="-fuse-ld=lld $LDFLAGS"
%endif
%DQ6build \
    -DCMAKE_INSTALL_LIBDIR=%_libdir \
#

%install
%DQ6install
%find_lang --with-qt %name

%files -f %name.lang
%doc README.md LICENSE.txt debian/changelog
%_bindir/%name
%dir %_datadir/%name/
%dir %_datadir/%name/themes/
%_datadir/%name/themes/*.theme
# package translations outside %%find_lang
%dir %_datadir/%name/translations/
%_datadir/%name/translations/%name.qm
# ---
%dir %_datadir/%name/org.kde.syntax-highlighing/
%dir %_datadir/%name/org.kde.syntax-highlighing/syntax/
%_datadir/%name/org.kde.syntax-highlighing/syntax/vbscript.xml
%_desktopdir/%name.desktop
%_iconsdir/hicolor/scalable/apps/%name.svg
%dir %_datadir/dsg/
%dir %_datadir/dsg/configs/
%dir %_datadir/dsg/configs/org.deepin.editor/
%_datadir/dsg/configs/org.deepin.editor/org.deepin.editor.json
%dir %_datadir/deepin-manual/
%dir %_datadir/deepin-manual/manual-assets/
%dir %_datadir/deepin-manual/manual-assets/application/
%dir %_datadir/deepin-manual/manual-assets/application/%name/
%_datadir/deepin-manual/manual-assets/application/%name/editor/

%changelog
