%define repo dde-calendar

Name: deepin-calendar
Version: 6.5.29
Release: alt1

Summary: Calendar for Deepin Desktop Environment

License: LGPL-3.0-or-later
# ./3rdparty/kcalendarcore/src/ contains license(s) LGPL-2.0-or-later
Group: Graphical desktop/Other
Url: https://github.com/linuxdeepin/dde-calendar
VCS: https://github.com/linuxdeepin/dde-calendar

# Source-url: https://github.com/linuxdeepin/dde-calendar/archive/%version/%repo-%version.tar.gz
Source: %repo-%version.tar
Patch0: %name-%version-%release.patch
Patch1: deepin-calendar-5.12.1-alt-fix-GNUInstallDirs.patch

Requires: icon-theme-hicolor

BuildRequires(pre): rpm-build-ninja rpm-macros-dqt6
BuildRequires: cmake dtk6-common-devel libdtk6widget-devel libical-devel dqt6-svg-devel dqt6-tools-devel libcups-devel
BuildRequires: dqt6-sql-interbase dqt6-sql-mysql dqt6-sql-odbc dqt6-sql-postgresql

%description
Calendar for Deepin Desktop Environment.

%prep
%setup -n %repo-%version
%autopatch -p1

%build
export LC_ALL=C.UTF-8
%DQ6build \
  -DLIB_DESTINATION=%_lib \
  -DCMAKE_INSTALL_LIBDIR=%_libdir \
  -DSERVICE_INSTALL_DIR=%_libexecdir/deepin-daemon \
  -DCMAKE_INSTALL_SYSCONFDIR=%_sysconfdir \
  -DVERSION=%version

%install
%DQ6install
%find_lang --with-qt %repo

%files -f %repo.lang
%doc README.md LICENSE debian/changelog
%_bindir/%repo
%dir %_datadir/%repo/
%dir %_datadir/%repo/translations/
%_datadir/%repo/translations/dde-calendar-service.qm
%_datadir/%repo/translations/dde-calendar.qm
%dir %_datadir/%repo/data/
%_datadir/%repo/data/huangli.db
%_datadir/dbus-1/services/com.deepin.Calendar.service
%_datadir/dbus-1/services/com.deepin.dataserver.Calendar.service
%_datadir/metainfo/org.deepin.calendar.metainfo.xml
%_desktopdir/%repo.desktop
%_sysconfdir/xdg/autostart/dde-calendar-service.desktop
%dir %_libexecdir/deepin-daemon/
%_libexecdir/deepin-daemon/dde-calendar-service
%dir %_libdir/deepin-aiassistant/
%dir %_libdir/deepin-aiassistant/serivce-plugins/
%_libdir/deepin-aiassistant/serivce-plugins/libuosschedulex-plugin.so
%dir %_datadir/deepin-manual/
%dir %_datadir/deepin-manual/manual-assets/
%dir %_datadir/deepin-manual/manual-assets/application/
%dir %_datadir/deepin-manual/manual-assets/application/%repo/
%_datadir/deepin-manual/manual-assets/application/%repo/calendar/
%dir %_datadir/deepin-log-viewer/
%dir %_datadir/deepin-log-viewer/deepin-log.conf.d/
%_datadir/deepin-log-viewer/deepin-log.conf.d/dde-calendar.json
%_userunitdir/com.dde.calendarserver.calendar.service
%_userunitdir/com.dde.calendarserver.calendar.timer
%_userunitdir/%repo.service
%dir %_datadir/dsg/
%dir %_datadir/dsg/configs/
%dir %_datadir/dsg/configs/org.deepin.dde.calendar/
%_datadir/dsg/configs/org.deepin.dde.calendar/org.deepin.dde.calendar*.json
%dir %_datadir/deepin-debug-config/
%dir %_datadir/deepin-debug-config/deepin-debug-config.d/
%_datadir/deepin-debug-config/deepin-debug-config.d/org.deepin.dde.calendar.json

%changelog
