%define repo dde-appearance

%def_disable clang

Name: deepin-appearance
Version: 1.1.71
Release: alt1

Summary: Set the theme and appearance of DDE

License: GPL-3.0+
Group: Graphical desktop/Other
Url: https://github.com/linuxdeepin/dde-appearance
Vcs: https://github.com/linuxdeepin/dde-appearance

Provides: %repo = %EVR

# Source-url: %url/archive/%version/%repo-%version.tar.gz
Source: %repo-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-build-ninja rpm-macros-dqt6
BuildRequires: cmake dqt6-tools-devel dqt6-declarative-devel dtk6-common-devel libdtk6gui-devel kf6-kconfig-devel kf6-kwindowsystem-devel kf6-kglobalaccel-devel libgio-devel libXcursor-devel libXfixes-devel libgtk+3-devel libxcbutil-cursor-devel libsystemd-devel
%if_enabled clang
BuildRequires(pre): clang-devel
%else
BuildRequires(pre): gcc-c++
%endif

%description
%summary.

%prep
%setup -n %repo-%version
%patch -p1

%build
%if_enabled clang
export CC="clang"
export CXX="clang++"
export LDFLAGS="-fuse-ld=lld $LDFLAGS"
%endif
%DQ6build

%install
%DQ6install
%find_lang --with-qt plugin-dde-appearance

%files -f plugin-dde-appearance.lang
%doc README.md LICENSE debian/changelog
%_bindir/dde-fakewm
%_userunitdir/dde-fakewm.service
%dir %_libdir/deepin-service-manager/
%_libdir/deepin-service-manager/libplugin-dde-appearance.so
%dir %_datadir/deepin-service-manager/
%dir %_datadir/deepin-service-manager/user/
%_datadir/deepin-service-manager/user/plugin-dde-appearance.json
%dir %_datadir/%repo/
%_datadir/%repo/custom.png
# package outside find_lang
%dir %_datadir/plugin-dde-appearance/
%dir %_datadir/plugin-dde-appearance/translations/
%_datadir/plugin-dde-appearance/translations/dde-appearance_ky@Arab.qm
# ---
%_datadir/dbus-1/services/com.deepin.wm.service
%_datadir/dbus-1/services/org.deepin.dde.Appearance1.service
%dir %_datadir/dsg/
%dir %_datadir/dsg/configs/
%dir %_datadir/dsg/configs/org.deepin.dde.appearance/
%_datadir/dsg/configs/org.deepin.dde.appearance/org.deepin.dde.appearance.json

%changelog
