%define _sysusersdir %_prefix/lib/sysusers.d

Name: deepin-anything
Version: 7.0.23
Release: alt1

Summary: The lightning-fast filename search for Deepin

License: GPL-3.0+
Group: Graphical desktop/Other
Url: https://github.com/linuxdeepin/deepin-anything
Vcs: git://github.com/linuxdeepin/deepin-anything.git

Source: %url/archive/%version/%name-%version.tar.gz
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-macros-dqt6 rpm-build-kernel
BuildRequires: cmake glib2-devel libgio-devel libdtk6core-devel libmount-devel libnl-devel libpcre-devel libudisks2-qt6-devel boost-devel libspdlog-devel liblucene++-devel dqt6-base-devel

%description
%summary.
It is provides offline search functions.

%package -n kernel-source-%name
Summary: Kernel source for %name module
Group: Development/Kernel
BuildArch: noarch

%description -n kernel-source-%name
This is the source of the kernel %name module.

%prep
%setup
%autopatch -p1

%build
%DQ6build \
  -DCMAKE_INSTALL_LIBDIR=%_libdir \
#

%install
%DQ6install
install -Dm644 archlinux/deepin-anything-server.sysusers %buildroot%_sysusersdir/deepin-anything-server.conf
cd %kernel_srcdir
tar -cJhf %name-0.0.tar.xz %name-0.0/
rm -rf %name-0.0/

%files
%doc README.md LICENSE CHANGELOG.md
%_bindir/deepin-anything-daemon
%_bindir/deepin-anything-server
%_bindir/deepin-anything-searcher
%_userunitdir/deepin-anything-daemon.service
%_sysusersdir/*.conf
%_sysconfdir/modules-load.d/anything.conf
%dir %_datadir/deepin-anything-server/
%_datadir/deepin-anything-server/pinyin.txt
%dir %_datadir/dsg/
%dir %_datadir/dsg/configs/
%dir %_datadir/dsg/configs/org.deepin.anything/
%_datadir/dsg/configs/org.deepin.anything/org.deepin.anything.json

%files -n kernel-source-%name
%dir %_usrsrc/kernel/
%_usrsrc/kernel/*

%changelog
