%define _unpackaged_files_terminate_build 1

%define _libexecdir %_prefix/libexec
%define _localstatedir %_var
%def_enable introspection
%def_enable systemd

Name: dde-lightdm
Version: 1.32.0
Release: alt9.dde.1
Summary: Lightweight Display Manager
Group: Graphical desktop/Other
License: GPLv3+
Url: https://github.com/canonical/lightdm

Source: %name-%version.tar

Patch1:  %name-1.32.0-cancelling.patch
#Patch2:  %name-1.30.0-chauthtok.patch
#Patch3:  %name-1.32.0-default-session.patch
#Patch4:  %name-1.30.0-default-username.patch
Patch5:  %name-1.30.0-login-unknown.patch
#Patch6:  %name-1.30.0-switch.patch
Patch7:  %name-1.30.0-alt-env.patch
Patch8:  %name-1.32.0-alt-config.patch
Patch9:  %name-1.30.0-alt-01-Xgreeter.patch
Patch10: %name-1.30.0-alt-02-hide-users.patch
Patch11: %name-1.30.0-alt-03-login-unknown.patch
Patch12: %name-1.32.0-alt-pam-2.0.patch
Patch13: %name-1.30.0-alt-polkit.patch
Patch14: %name-1.30.0-alt-shells.patch
Patch15: %name-1.30.0-alt-04-systemd.patch
Patch16: %name-1.30.0-alt-05-tmpfiles.patch
Patch17: %name-1.32.0-update-user.patch
Patch18: %name-1.32.0-pam-locale.patch
Patch19: %name-1.32.0-alt-i18n.patch
Patch20: %name-1.30.0-alt-wayland-session.patch
Patch21: %name-1.30.0-alt-lock-tty.patch
Patch22: %name-1.30.0-alt-select-vt.patch
Patch23: %name-1.32.0-session-sort.patch
Patch24: %name-1.32.0-testfix.patch
Patch25: %name-1.32.0-testfix_alt.patch
Patch26: %name-1.32.0-addrfix.patch
Patch27: %name-1.32.0-qt6-library.patch
Patch28: %name-1.32.0-wrapper-args.patch

# find libraries
%add_findprov_lib_path %_dqt6_libdir

BuildRequires: gcc-c++ intltool
BuildRequires: pkgconfig(glib-2.0) >= 2.30 pkgconfig(gio-2.0) >= 2.26  pkgconfig(gio-unix-2.0)  pkgconfig(xdmcp)  pkgconfig(xcb)
BuildRequires: pkgconfig(gobject-2.0)
BuildRequires: pkgconfig(xcb)
BuildRequires: libdbus-glib-devel
BuildRequires: gtk-doc yelp-tools itstool
BuildRequires: libpam-devel
BuildRequires: libgcrypt-devel
BuildRequires: libvala-devel vala-tools
BuildRequires: libaudit-devel
BuildRequires: pkgconfig(glib-2.0) pkgconfig(gio-2.0) >= 2.26 pkgconfig(gio-unix-2.0) pkgconfig(gobject-2.0) pkgconfig(libxklavier) pkgconfig(x11)
%{?_enable_introspection:BuildRequires: gobject-introspection-devel}
BuildRequires: dqt6-base-devel

# For make check:
BuildRequires: dbus python3 python3-module-pygobject3

%description
LightDM is a lightweight, cross-desktop display manager. Its main features are
a well-defined greeter API allowing multiple GUIs, support for all display
manager use cases, with plugins where appropriate, low code complexity, and
fast performance. Due to its cross-platform nature greeters can be written in
several toolkits, including HTML/CSS/Javascript.

%package -n dde-liblightdm-gobject
Group: System/Libraries
Summary: LightDM GObject Greeter Library
License: LGPLv2+

%description -n dde-liblightdm-gobject
A library for LightDM greeters based on GObject which interfaces with LightDM
and provides common greeter functionality.

%package -n liblightdm-dqt6
Group: System/Libraries
Summary: LightDM Qt6 Greeter Library
License: LGPLv2+

%description -n liblightdm-dqt6
A library for LightDM greeters based on Qt6 which interfaces with LightDM and
provides common greeter functionality.

%package devel
Group: Development/C
Summary: Development Files for LightDM

%description devel
This package provides all necessary files for developing plugins, greeters, and
additional interface libraries for LightDM.

%prep
%setup
%autopatch -p1

%ifarch %e2k
# until apx. lcc-1.23.01
sed -i 's,-Werror=pointer-arith,,' configure.ac
%endif

# Fix tests with new D-Bus (see a70b042f in dbus package):
sed -i -e "s,unix:tmpdir=/tmp,unix:tmpdir=$TMPDIR,g" \
    tests/data/session.conf tests/data/system.conf

# Find needed requires:
sed -i -e "/Requires/d" \
    liblightdm-qt/liblightdm-qt6-3.pc.in

%build
%ifarch %e2k
export CXXFLAGS="%optflags -std=gnu++11"
%endif
export PKG_CONFIG_PATH=%_dqt6_libdir/pkgconfig:$PKG_CONFIG_PATH
export PATH=%_dqt6_bindir:$PATH
%autoreconf
%configure \
	%{subst_enable introspection} \
	--disable-static \
	--enable-tests \
	--enable-gtk-doc \
	--enable-liblightdm-qt6 \
	--libexecdir=%_dqt6_libexecdir \
	--libdir=%_dqt6_libdir \
	--bindir=%_libexecdir/dqt6/bin \
	--includedir=%_dqt6_headerdir \
	--with-greeter-user=_ldm \
	--with-greeter-session=%name-default-greeter \
#

%make_build

%install
%make DESTDIR=%buildroot install unitdir=%_unitdir
# build qt6 library only
rm -rf %buildroot%_sysconfdir
rm -rf %buildroot/lib
rm -rf %buildroot%_datadir
rm -rf %buildroot%_unitdir
rm -rf %buildroot%_dqt6_libexecdir
rm -rf %buildroot%_libexecdir/dqt6
rm -rf %buildroot%_sbindir
rm -rf %buildroot/var/lib/ldm/.pam_environment
rm -rf %buildroot%_dqt6_libdir/liblightdm*.la
rm -rf %buildroot%_dqt6_libdir/girepository*

%files -n dde-liblightdm-gobject
%_dqt6_libdir/liblightdm-gobject-?.so.*

%files -n liblightdm-dqt6
%_dqt6_libdir/liblightdm-qt6-?.so.*

%files devel
%_dqt6_libdir/*.so
%_dqt6_headerdir/*
%_dqt6_libdir/pkgconfig/*.pc
# %_datadir/vala/vapi/*

%changelog
