%def_enable check

Name: dbus-broker
Version: 37
Release: alt1

Summary: Linux D-Bus Message Broker
License: Apache-2.0
Group: System/Servers
Url: https://github.com/bus1/dbus-broker
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Source: https://github.com/bus1/dbus-broker/releases/download/v%version/%name-%version.tar.xz

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson pkgconfig(audit) pkgconfig(expat) pkgconfig(dbus-1) pkgconfig(libcap-ng)
BuildRequires: pkgconfig(libselinux) pkgconfig(libsystemd) pkgconfig(systemd) python3-module-docutils

%description
dbus-broker is an implementation of a message bus as defined by the D-Bus
specification. Its aim is to provide high performance and reliability, while
keeping compatibility to the D-Bus reference implementation. It is exclusively
written for Linux systems, and makes use of many modern features provided by
recent Linux kernel releases.

%prep
%setup

%build
%meson \
    -Dselinux=true \
    -Daudit=true \
    -Ddocs=true \
    -Dlauncher=true \
    -Dlinux-4-17=true
%nil
%meson_build

%install
%meson_install

%check
%__meson_test

%files
%_bindir/%name
%_bindir/%name-launch
%_unitdir/%name.service
%_journal_catalogdir/*.catalog
%_userunitdir/%name.service
%_man1dir/*.1*
%doc README* NEWS*

%changelog
