Name: dblatex
Version: 0.3.12
Release: alt3

Summary: DocBook to LaTeX/ConTeXt Publishing

License: GPL-2.0-or-later and MIT and W3C
Group: Text tools
Url: http://dblatex.sourceforge.net

Source: %name-%version.tar

Patch: dblatex-0.3.11-disable-debian.patch
Patch1: dblatex-0.3.11-which-shutil.patch
Patch2: dblatex-0.3.11-replace-inkscape-by-rsvg.patch
Patch3: dblatex-0.3.12-replace-imp-by-importlib.patch
Patch4: dblatex-0.3.12-adjust-submodule-imports.patch
Patch5: dblatex-0.3.12-fix-syntax-warnings.patch

# ImageMagick-tools or GraphicsMagick-ImageMagick-compat
Requires: /usr/bin/convert
Requires: xsltproc docbook-dtds

BuildRequires(pre): rpm-build-python3 rpm-build-tex
BuildRequires: python3-devel texlive-latex-extra xsltproc
BuildRequires: transfig

BuildArch: noarch

# this is xelatex's sty, skip to workaround texmf dep tracing unefficiency
%add_texmf_req_skip xecyr.sty
# 4Suite python2 only, xsltproc will be used
%filter_from_requires /Ft\./d

%define _dblatex_datadir %_datadir/%name
%define _dblatex_texdir %_texmfmain/tex/latex/%name

%description
Dblatex started as a DB2LaTeX clone, but since then many things have changed
and new features have been added or (hopefully) improved. Now, the portion of
shared code is small if any, and the dblatex purpose is different from DB2LaTeX
on these points:

    * The project is end-user oriented, that is, it tries to hide as much as
    * possible the latex compiling stuff by providing a single clean script to
    * produce directly DVI, PostScript and PDF output.  The actual output
    * rendering is done not only by the XSL stylesheets transformation, but
    * also by a dedicated LaTeX package. The goal is to allow a deep LaTeX
    * customisation without changing the XSL stylesheets.  Post-processing is
    * done by Python, to make publication faster, convert the images if needed,
    * and do the whole compilation.

This project is splitted in two instances working on the same principles. Both
instances are intended to produce DVI, PostScript, PDF documents from DocBook
SGML or XML sources, by converting first to a high level set of TeX macros.

%prep
%setup
%patch -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
# \cyrchar is not defined, attempts to use it are unjustified
sed -i 's/\\cyrchar//g' lib/dbtexmf/dblatex/unient.py

#fix shebangs
sed -i 's|\(/usr/bin/\)env \(python\)$|\1\23|' \
scripts/dblatex tools/pdfscan.py \
lib/dbtexmf/dblatex/xetex/*.py

rm -rv lib/contrib

%build
%python3_build

%install
%python3_install

mkdir -p %buildroot/%_dblatex_texdir
mv %buildroot/%_dblatex_datadir/latex/{contrib,misc/multirow2.sty,style} %buildroot/%_dblatex_texdir
rm -rvf %buildroot/%_dblatex_datadir/latex/misc

mkdir -p %buildroot/%_dblatex_datadir/latex
ln -s ../../texmf/tex/latex/dblatex/contrib %buildroot/%_dblatex_datadir/latex/contrib
mv %buildroot/%_dblatex_datadir/latex/graphics %buildroot/%_dblatex_texdir

mv %buildroot%_docdir/%name %buildroot%_docdir/%name-%version
cp COPYRIGHT %buildroot%_docdir/%name-%version

# another fix shebang
sed -i 's|\(/usr/bin/\)env \(python\)$|\1\23|' %buildroot%_bindir/%name

%files
%_bindir/%name
%_dblatex_datadir
%_dblatex_texdir
%python3_sitelibdir/dbtexmf/
%python3_sitelibdir/*.egg-info
%_docdir/%name-%version
%_man1dir/%name.1*

%changelog
