%def_disable snapshot
%define _name cxxopts

%def_disable unicode_help
%def_enable check

Name: %_name
Version: 3.3.1
Release: alt1

Summary: Lightweight C++ option parser library
License: MIT
Group: System/Libraries
Url: https://github.com/jarro2783/cxxopts

%if_disabled snapshot
Source: %url/archive/v%version/%_name-%version.tar.gz
%else
Source: %_name-%version.tar
%endif

%{?_disable_unicode_help:BuildArch: noarch}

BuildRequires(pre): rpm-macros-cmake
BuildRequires: gcc-c++ cmake
%{?_enable_unicode_help:BuildRequires: pkgconfig(icu-cu)}
%{?_enable_check:BuildRequires: ctest}

%description
This is a lightweight C++ option parser library, supporting the standard
GNU style syntax for options.

%package devel
Summary: Development files for %name
Group: Development/C++

%description devel
Development files for %name.

%prep
%setup -n %_name-%version

%ifarch %e2k
sed -i 's/-Werror/-Wno-error/' cmake/cxxopts.cmake
%endif

%build
%cmake -DCMAKE_BUILD_TYPE=Release \
    %{?_enable_unicode_help:-DCXXOPTS_USE_UNICODE_HELP=ON}
%nil
%cmake_build

%install
%cmake_install

%check
%ctest

%files devel
%_includedir/%_name.hpp
%if_enabled unicode_help
%_libdir/cmake/%_name/
%_pkgconfigdir/%_name.pc
%else
%_datadir/cmake/%_name/
%_datadir/pkgconfig/%_name.pc
%endif

%changelog
