%define cve_group   cve
%define backup      cve-backup
%define history     cve-history
%define download    cve-download
%define import      cve-import
%define map         cpe-map
%define map_special *-map-special
%define issues      cve-issues
%define iprep       %{issues}-prep
%define monitor     cve-monitor
%define mail        cve-mail
%define vuln_list   %{name}-vuln-list
%define alt_errata  %{name}-vs-alt-errata
%define libcommon   libcve-manager
%define common      %{name}-common
%define python3_sp  /usr/lib/python3/site-packages
%define common_sp   %{python3_sp}/cve_manager
%define backup_sp   %{python3_sp}/cve_backup
%define map_sp      %{python3_sp}/cpe_map
%define choice_sp   %{python3_sp}/cpe_map_choice
%define issues_sp   %{python3_sp}/cve_issues
%define monitor_sp  %{python3_sp}/cve_monitor
%define knowledge   %{name}-inner-knowledge
%define get_urls    get-homepage-urls
%define statedir    %{_localstatedir}/%{name}

%define lcontrolpp_ver 0.35
%define ltree_ver      0.12
%define ax_ver         0.21
%define sisyphus_ver   0.22
%define verlib_ver     0.21
%define knowledge_ver  2023.04.03

Name: cve-manager
Version: 0.102.4
Release: alt1

Summary: CVE-management toolkit
License: GPLv3
Group: Other
Url: https://www.altlinux.org/CVE-Manager

Packager: Alexey Appolonov <alexey@altlinux.org>

# http://git.altlinux.org/people/alexey/packages/?p=cve-manager.git
Source: %{name}-%{version}.tar

# For cve-import
BuildRequires: gcc-c++
BuildRequires: libcontrol++-devel >= %{lcontrolpp_ver}
BuildRequires: libtree-devel >= %{ltree_ver}
BuildRequires: libmysqlcppconn-devel
BuildRequires: libcurl-devel

# For py-modules
BuildRequires: rpm-build-python3
Requires: python3
Requires: python3-module-ax >= %{ax_ver}
Requires: python3-module-sisyphus >= %{sisyphus_ver}
Requires: python3-module-verlib >= %{verlib_ver}
Requires: python3-module-mysql
Requires(pre): %{common}
Requires: %{libcommon}
Requires: %{backup}
Requires: %{history}
Requires: %{download}
Requires: %{import}
Requires: %{map}
Requires: %{issues}
Requires: %{monitor}
Requires: %{knowledge} >= %{knowledge_ver}

ExcludeArch: i586
ExcludeArch: armh

%description
%{name} is an utilities toolkit used to form a database of vulnerabilities
(VUL DB) using MySQL, and to provide an easy interface to that DB.

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

%package -n %{backup}
Summary: CVE DB backupper/restorer
Group: Other

Requires: %{common}

%description -n %{backup}
%{backup} is an utility used to backup and restore a VUL DB.

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

%package -n %{history}
Summary: Tracker of CVE-dynamics
Group: Other

Requires: %{common}

%description -n %{history}
%{history} is an utility used to save records about currently unfixed issues
detected with the cve-issues module and to save a current map of names of
products to names of packages.

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

%package -n %{download}
Summary: CVE-lists and CPE dictionary downloader
Group: Other

Requires: %{common}
Requires: python3-module-requests
Requires: wget
Requires: git-core

%description -n %{download}
%{download} is an utility used to download lists with descriptions of
vulnerabilities (from various sources) and a CPE dictionary via HTTPS.

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

%package -n %{import}
Summary: Data parser and MySQL DB importer
Group: Other

Requires: %{common}
Requires: %{libcommon}
Requires: libcontrol++ >= %{lcontrolpp_ver}

Obsoletes: cve-fixes

%description -n %{import}
%{import} is an utility used to import lists of packages of examined repos,
various lists with descriptions of vulnerabilities (in JSON and XML format)
and a CPE dictionary into VUL DB.

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

%package -n %{map}
Summary: CPE list to software packages list mapper
Group: Other

Requires: %{common}

%description -n %{map}
%{map} is an utility used to map names of products used in descriptions
of vulnerabilities (imported to a VUL DB) to names of packages (--//--).

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

%package -n %{issues}
Summary: CVE-issues detector
Group: Other

Requires: %{common}

%description -n %{issues}
%{issues} is an utility used to detect issues related to vulnerabilities of
the packages and then create records for those issues in a VUL DB for latter
access via cve-monitor and cve-history modules.

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

%package -n %{iprep}
Summary: Exporter of a shortened version of a CVE DB
Group: Other

Requires: %{common}

%description -n %{iprep}
%{iprep} is an utility used to export all needed data used by the cve-issues
utility to detect issues.

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

%package -n %{monitor}
Summary: CVE database monitor
Group: Other

Requires: %{common}

%description -n %{monitor}
%{monitor} is an utility used to query VUL DB and form human-readable reports
that can be sent via SMPT on request.

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

%package -n %{vuln_list}
Summary: Generator of "vuln-list" files for detected issues.
Group: Other

Requires: %{common}
Requires: %{issues}

%description -n %{vuln_list}
%{vuln_list} is an utility used to generate "vuln-list" files for all
vulnerability issues detected in specified repositories.

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

%package -n %{alt_errata}
Summary: Utility used to compare issues detected by cve-manager with ALT errata
Group: Other

Requires: %{common}
Requires: %{monitor}

%description -n %{alt_errata}
%{alt_errata} is an utility used to compare issues detected by cve-manager with
issues included in ALT errata.

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

%package -n %{libcommon}
Summary: C++ lib with common functionality
Group: Other

Requires: libtree >= %{ltree_ver}

%description -n %{libcommon}
C++ library with common functionality such as connecting to MySQL DB and
parsing the main configuration file.

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

%package -n %{common}
Summary: Common files of the CVE manager
Group: Other

%description -n %{common}
Common files such as a config file and a cve-manager py-library.

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

%prep
%setup

%build
%make_build -C libcve-manager/
%make_build -C cve-import/

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

%install

# Preparing dirs
mkdir -p \
	%{buildroot}%{_bindir} \
	%{buildroot}%{_libdir} \
	%{buildroot}%{_defaultdocdir}/%{name} \
	%{buildroot}%{_sysconfdir}/%{name} \
	%{buildroot}%{backup_sp} \
	%{buildroot}%{map_sp} \
	%{buildroot}%{choice_sp} \
	%{buildroot}%{issues_sp} \
	%{buildroot}%{monitor_sp} \
	%{buildroot}%{common_sp} \
	%{buildroot}%{statedir}

# Installing executables
install -m0750 \
	%{import}/bin/%{import} \
	%{name} \
	%{backup} \
	%{history} \
	%{download} \
	%{map}* \
	%{map_special} \
	%{issues} \
	%{iprep} \
	%{get_urls} \
	%{buildroot}%{_bindir}
install -m0755 \
	%{monitor} \
	%{vuln_list} \
	%{alt_errata} \
	%{buildroot}%{_bindir}
install -m0750 cve_backup/*     %{buildroot}%{backup_sp}
install -m0750 cpe_map/*        %{buildroot}%{map_sp}
install -m0750 cpe_map_choice/* %{buildroot}%{choice_sp}
install -m0750 cve_issues/*     %{buildroot}%{issues_sp}
install -m0755 cve_monitor/*    %{buildroot}%{monitor_sp}
install -m0755 cve_manager/*    %{buildroot}%{common_sp}
install -m0755 %{libcommon}/bin/%{libcommon}.so %{buildroot}%{_libdir}

# Installing configs (user should be in the 'cve' group to use cve-manager)
cp -r samples/* %{buildroot}%{_sysconfdir}/%{name}
chmod 660 %{buildroot}%{_sysconfdir}/%{name}/%{name}.conf
chmod 660 %{buildroot}%{_sysconfdir}/%{name}/%{mail}.conf
chmod 664 %{buildroot}%{_sysconfdir}/%{name}/%{monitor}.conf

# Installing documentation
cp COPYING readme.txt %{buildroot}%{_defaultdocdir}/%{name}/

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
# Conf file and modules that modify CVEDB belong to the grp of cve-manager usrs

%post -n %{common}
# Creating group for cve-manager users if it doesn't exists
if ! grep -q %{cve_group} /etc/group; then
	groupadd %{cve_group}
fi
chgrp cve \
	%{_sysconfdir}/%{name}/%{name}.conf \
	%{statedir}
chmod 775 %{statedir}

%post
chgrp cve %{_bindir}/%{name}

%post -n %{backup}
chgrp cve \
	%{_bindir}/%{backup} \
	%{backup_sp}/*

%post -n %{history}
chgrp cve %{_bindir}/%{history}

%post -n %{download}
chgrp cve %{_bindir}/%{download}

%post -n %{import}
chgrp cve %{_bindir}/%{import}
chgrp cve %{_bindir}/%{get_urls}

%post -n %{map}
chgrp cve \
	%{_bindir}/%{map}* \
	%{_bindir}/%{map_special} \
	%{map_sp}/* \
	%{choice_sp}/*

%post -n %{issues}
chgrp cve \
	%{_bindir}/%{issues} \
	%{issues_sp}/*

%post -n %{iprep}
chgrp cve %{_bindir}/%{iprep}

%post -n %{monitor}
chgrp cve \
	%{_sysconfdir}/%{name}/%{monitor}.conf \
	%{_sysconfdir}/%{name}/%{mail}.conf

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

%files
%{_bindir}/%{name}

%files -n %{download}
%{_bindir}/%{download}

%files -n %{backup}
%{_bindir}/%{backup}
%{backup_sp}

%files -n %{history}
%{_bindir}/%{history}

%files -n %{import}
%{_bindir}/%{import}
%{_bindir}/%{get_urls}

%files -n %{map}
%{_bindir}/%{map}*
%{_bindir}/%{map_special}
%{map_sp}
%{choice_sp}

%files -n %{issues}
%{_bindir}/%{issues}
%{issues_sp}

%files -n %{iprep}
%{_bindir}/%{iprep}

%files -n %{monitor}
%{_bindir}/%{monitor}
%{monitor_sp}
%config(noreplace) %{_sysconfdir}/%{name}/%{monitor}.conf
%config(noreplace) %{_sysconfdir}/%{name}/%{mail}.conf

%files -n %{vuln_list}
%{_bindir}/%{vuln_list}

%files -n %{alt_errata}
%{_bindir}/%{alt_errata}

%files -n %{libcommon}
%{_libdir}/%{libcommon}.so

%files -n %{common}
%{common_sp}
%{_defaultdocdir}/%{name}
%dir %{_sysconfdir}/%{name}/
%config(noreplace) %{_sysconfdir}/%{name}/%{name}.conf
%dir %{statedir}

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

%changelog
