%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
%def_with nghttp2
%def_with libssh2
%def_with check
%def_disable static

# QUIC protocol not supported in standart openssl, ngtcp2 build with gnutls for http3 support
%if "%(rpmvercmp '%{get_version libgnutls30}' '3.7.9')" < "0"
%def_disable http3
%else
%def_enable http3
%endif

%if_enabled http3
  %def_without openssl
  %def_with gnutls
  %def_with ngtcp2
  %def_with nghttp3
%else
  %def_with openssl
  %def_without gnutls
  %def_without ngtcp2
  %def_without nghttp3
%endif

# relaxed check on armh (test 650 fail, but the architecture is a little not supported)
%ifarch armh
%define relax ||:
%else
%define relax %nil
%endif

Name: curl
Version: 8.17.0
Release: alt1

Summary: Gets a file from a FTP, GOPHER or HTTP server
Summary(ru_RU.UTF-8): Утилиты и библиотеки для передачи файлов
License: MIT
Group: Networking/File transfer
Url: https://curl.se/
VCS: https://github.com/curl/curl

Source: %url/download/%name-%version.tar
Source1: %name.watch
Patch0: curl-%version-alt.patch

Requires: lib%name = %EVR

# check QUIC possibility
BuildRequires: libgnutls30

%{?_enable_static:BuildRequires: glibc-devel-static}
BuildRequires: groff-base
BuildRequires: libidn2-devel libkrb5-devel libgsasl-devel
BuildRequires: zlib-devel libzstd-devel libpsl-devel libldap-devel libbrotli-devel
%if_with check
BuildRequires: python3-base
BuildRequires: /proc
BuildRequires: libnghttp2-tools
BuildRequires: gnutls-utils
BuildRequires: /usr/bin/stunnel
BuildRequires: perl(Digest/SHA.pm)
BuildRequires: perl(Memoize.pm)
BuildRequires: openssh-server
BuildRequires: openssh-clients
BuildRequires: caddy
BuildRequires: pytest3
BuildRequires: python3-module-cryptography
# for pytest
BuildRequires: apache2-httpd-worker
BuildRequires: apache2-devel
BuildRequires: apache2-mod_ssl
BuildRequires: apache2-mod_http2
BuildRequires: vsftpd
BuildRequires: python3-module-pytest-xdist
BuildRequires: python3-module-psutil
BuildRequires: python3-module-filelock
BuildRequires: libnghttp2-tools
%endif

%{?_with_openssl:BuildRequires: libssl-devel}
%{?_with_gnutls:BuildRequires: libgnutls-devel libnettle-devel}
%{?_with_libssh2:BuildRequires: libssh2-devel}
%{?_with_nghttp2:BuildRequires: libnghttp2-devel}
%{?_with_ngtcp2:BuildRequires: libngtcp2-devel >= 0.15.0}
%{?_with_nghttp3:BuildRequires: libnghttp3-devel}

%package -n lib%name
Summary: The shared library for file transfer
Summary(ru_RU.UTF-8): Библиотеки для передачи файлов
Group: System/Libraries
Provides: %name-lib = %version
Obsoletes: %name-lib < %version
Requires: ca-certificates

%package -n lib%name-devel
Summary: Header files for lib%name
Summary(ru_RU.UTF-8): Заголовочные файлы для lib%name
Group: Development/C
Requires: lib%name = %version-%release bc
Provides: %name-devel = %version
Obsoletes: %name-devel < %version

%package -n lib%name-devel-static
Summary: Static libraries for lib%name
Summary(ru_RU.UTF-8): Статические библиотеки для lib%name
Group: Development/C
Requires: lib%name-devel = %version-%release

%description
Curl is a client to get documents/files from servers, using any of the
supported protocols. The command is designed to work without user
interaction or any kind of interactivity.

Curl offers a busload of useful tricks like proxy support, user
authentication, ftp upload, HTTP post, file transfer resume and more.

%description -l ru_RU.UTF-8
Curl - это клиент для получения файлов или документов с серверов,
используя один из поддерживаемых протоколов.  Утилита спроектирована
для работы в неинтерактивном режиме.

Curl позволяет выполнять различные операции над сетевыми файлами,
реализуя поддержку прокси, авторизацию пользователя, докачку файлов и
многое другое.

%description -n lib%name
This package contains lib%name shared library of functions for
sending and receiving files through various protocols, including
http and ftp.

%description -n lib%name -l ru_RU.UTF-8
Этот пакет содержит разделяемую библиотеку функций для отправки или
получения файлов через различные сетевые протоколы, включая http и ftp.

%description -n lib%name-devel
This package contains lib%name development library of functions for
sending and receiving files through various protocols, including
http and ftp.

This package is required for development of applications that
utilize lib%name.

%description -n lib%name-devel -l ru_RU.UTF-8
Этот пакет содержит девелоперскую библиотеку функций для отправки или
получения файлов через различные сетевые протоколы, включая http и ftp.

Этот пакет необходим для разработки приложений, использующих lib%name.

%description -n lib%name-devel-static
This package contains lib%name static library of functions for
sending and receiving files through various protocols, including
http and ftp.

This package is required for development of statically linked
applications that utilize lib%name.

%description -n lib%name-devel-static -l ru_RU.UTF-8
Этот пакет содержит статическую библиотеку функций для отправки или
получения файлов через различные сетевые протоколы, включая http и ftp.

Этот пакет необходим для разработки статически слинкованных приложений,
использующих lib%name.

%prep
%setup -q
%patch0 -p1

%build
export PATH=/sbin:/usr/sbin:$PATH
./scripts/maketgz %version only
%autoreconf
%configure \
	%{subst_enable static} \
	%{subst_with openssl} \
	%{subst_with gnutls} \
	%{subst_with ngtcp2} \
	%{subst_with nghttp3} \
	--with-libidn2 \
	--enable-ipv6 \
	--enable-ldap \
	--enable-threaded-resolver \
	--enable-openssl-auto-load-config \
	--with-gssapi \
	--enable-websockets \
	--enable-versioned-symbols \
%if_with check
	--with-test-httpd \
	--with-test-vsftpd=/usr/sbin/vsftpd \
%endif
	%{subst_with libssh2} \
	--with-ca-bundle=%_datadir/ca-certificates/ca-bundle.crt

%make_build

%install
%makeinstall_std
%makeinstall_std -C docs/libcurl
rm -f %buildroot%_man1dir/mk-ca-bundle.*

%check
%make -j4 -k test-nonflaky %relax
pushd tests/http
python3 -m pytest -v ||:
popd

%files
%_bindir/curl
%_bindir/wcurl
%_man1dir/curl.1*
%_man1dir/wcurl.1*

%files -n lib%name
%_libdir/*.so.*

%doc CHANGES.md README* docs/{FAQ,FEATURES.md}

%files -n lib%name-devel
%_libdir/*.so
%_libdir/pkgconfig/libcurl.pc
%_bindir/curl-config
%_aclocaldir/libcurl.m4
%_includedir/*
%_man3dir/*
%_man1dir/curl-config.*
%doc docs/{THANKS,TODO,examples,BUGS.md,TheArtOfHttpScripting.md}

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif
 
%changelog
