Name:		cups-x2go
Version:	3.0.1.4
Release:	alt1.1

Summary:	CUPS backend for printing from X2Go
License:	GPLv2+
Group:		Publishing
Url:		http://www.x2go.org/
BuildArch:	noarch

# Upstream:	git://code.x2go.org/cups-x2go.git
Source:		%name-%version.tar

Patch1:		cups-x2go-setpdfwrite.patch

Requires:	perl
Requires:	x2goserver
Requires:	x2goserver-printing
Requires:	cups
Requires:	ghostscript
Requires:	openssh-clients

%description
X2Go is a server based computing environment with
- session resuming
- low bandwidth support
- session brokerage support
- client side mass storage mounting support
- audio support
- authentication by smartcard and USB stick

CUPS backend for printing from X2Go.

%prep
%setup
%patch1 -p1

%install
mkdir -p %buildroot%prefix/lib/cups/backend
# The cups-x2go backends wants root permissions. So give it to them.
# http://www.cups.org/documentation.php/doc-1.4/man-backend.html says:
# Backends without world execute permissions are run as the root user.
# Otherwise, the backend is run using the unprivileged user account,
# typically "lp".
install -p -m700 cups-x2go %buildroot%prefix/lib/cups/backend/
mkdir -p %buildroot%_sysconfdir/cups
cp -p cups-x2go.conf %buildroot%_sysconfdir/cups/
mkdir -p %buildroot%_datadir/ppd/cups-x2go
cp -p CUPS-X2GO.ppd %buildroot%_datadir/ppd/cups-x2go/
mkdir -p %buildroot%_datadir/x2go/versions
cp -p VERSION.cups-x2go %buildroot%_datadir/x2go/versions/

%files
%prefix/lib/cups/backend/cups-x2go
%config(noreplace) %_sysconfdir/cups/cups-x2go.conf
%_datadir/x2go/versions/VERSION.cups-x2go
%dir %_datadir/ppd/cups-x2go
%_datadir/ppd/cups-x2go/*
%doc README.txt

%changelog
