%global import_path github.com/cue-lang/cue
Name:    cue
Version: 0.15.0
Release: alt1

Summary: Validate and define text-based and dynamic configuration
License: Apache-2.0
Group:   Other
Url:     https://github.com/cue-lang/cue

Packager: Mikhail Gordeev <obirvalger@altlinux.org>

Source: %name-%version.tar

BuildRequires(pre): rpm-build-golang
BuildRequires: golang

%description
Configure, Unify, Execute

CUE is an open source data constraint language which aims to simplify tasks
involving defining and using data.

It is a superset of JSON, allowing users familiar with JSON to get started
quickly.

%prep
%setup

%build
export BUILDDIR="$PWD/.build"
export IMPORT_PATH="%import_path"
export GOPATH="$BUILDDIR:%go_path"

export LDFLAGS="${LDFLAGS:-} -X cuelang.org/go/cmd/cue/cmd.version=%version"

%golang_prepare

cd .build/src/%import_path
%golang_build cmd/cue

%install
export BUILDDIR="$PWD/.build"
export IGNORE_SOURCES=1

%golang_install

mkdir -p %buildroot%_datadir/zsh/site-functions
%buildroot%_bindir/%name completion zsh > %buildroot%_datadir/zsh/site-functions/_%name
mkdir -p %buildroot%_datadir/bash-completion/completions
%buildroot%_bindir/%name completion bash > %buildroot%_datadir/bash-completion/completions/%name
mkdir -p %buildroot%_datadir/fish/vendor_completions.d
%buildroot%_bindir/%name completion fish > %buildroot%_datadir/fish/vendor_completions.d/%name.fish

%check
go test -v -run='!(^TestGenerate$)' ./...

%files
%doc *.md
%_bindir/*
%_datadir/zsh/site-functions/_%name
%_datadir/bash-completion/completions/%name
%_datadir/fish/vendor_completions.d/%name.fish

%changelog
