Name: cube3d
Version: 2005.08.29
Release: alt3

Summary: First person shooter game
License: Zlib license
Group: Games/Arcade

URL: http://www.cubeengine.com/
Source: cube-src-%version.tar
Patch0: cube3d-2005.08.29-alt-DSO.patch
Patch1: cube3d-2005.08.29-alt-fix-compilation.patch

Requires: cube3d-data >= 2005

# Automatically added by buildreq on Wed Jul 04 2007
BuildRequires: gcc-c++ libSDL-devel libSDL_image-devel libSDL_mixer-devel libX11-devel libGLU-devel zlib-devel
BuildRequires: desktop-file-utils

%description
Cube is an open source multiplayer and singleplayer first person shooter
game built on an entirely new and very unconventional engine. Cube is a
landscape-style engine that pretends to be an indoor FPS engine, which
combines very high precision dynamic occlusion culling with a form of
geometric mipmapping on the whole world for dynamic LOD for configurable
fps & graphic detail on most machines. Uses OpenGL & SDL. 

%prep
%setup -q -n cube-src-%version
%patch0 -p2
%patch1 -p2

%build
cd ./enet
touch NEWS AUTHORS ChangeLog
autoreconf -fisv
%configure
%make_build

cd ../src
%make_build CXXOPTFLAGS="%optflags -fsigned-char" CXX='g++ -L%_x11libdir'

%install
install -pD -m755 src/cube_client %buildroot%_gamesbindir/cube_client
install -pD -m755 src/cube_server %buildroot%_gamesbindir/cube_server
install -pD -m755 cube3d.sh %buildroot%_gamesbindir/cube3d

install -m755 -d %buildroot%_desktopdir/
cat > %buildroot%_desktopdir/%{name}.desktop <<EOF
[Desktop Entry]
Version=1.0
Type=Application
Name=The Cube shooter
Comment=The Cube shooter game
Exec=%_gamesbindir/cube3d
# TODO!!!
#Icon=%name
Terminal=false
StartupNotify=false
Categories=Game;Action;
EOF
desktop-file-install --dir %buildroot%_desktopdir \
	--remove-category=Action \
	--add-category=ActionGame \
	%buildroot%_desktopdir/cube3d.desktop

%files
%define _customdocdir %_docdir/cube3d
%doc readme.txt
%_gamesbindir/cube_client
%_gamesbindir/cube_server
%_gamesbindir/cube3d
%_desktopdir/%{name}.desktop

%changelog
