%define _unpackaged_files_terminate_build 1

# SPEC file for cryptsetup utility: setup crypto disks using
# /dev/mapper interface in 2.6.x kernels

%def_enable selinux

# defaults from configure
# crypto backend (gcrypt/openssl/nss/kernel/nettle)
%define default_crypto_backend openssl
%define default_luks_format LUKS2
%define _tmpfilesdir %(pkg-config --variable=tmpfilesdir systemd 2>/dev/null)

Name: cryptsetup
Version: 2.8.1
Release: alt1

Summary: Utility to setup a encrypted disks with LUKS support
Summary(ru_RU.UTF-8): Утилита управления зашифрованными дисковыми разделами с поддержкой LUKS

License: GPLv2+ and LGPLv2+
Group: System/Kernel and hardware
URL: https://gitlab.com/cryptsetup/cryptsetup/
# git: https://gitlab.com/cryptsetup/cryptsetup.git

Source0: %name-%version.tar
Source1: %name.README.ALT.utf-8
Source2: debian.tar
Patch0: %name-%version-%release.patch

Requires: lib%name = %version-%release

#BuildRequires(pre): rpm-macros-meson
#BuildRequires: meson >= 0.64
BuildRequires: libdevmapper-devel libpopt-devel libuuid-devel
BuildRequires: libudev-devel
BuildRequires: libpasswdqc-devel
BuildRequires: libjson-c-devel >= 0.12.1-alt2
BuildRequires: libargon2-devel
BuildRequires: libsystemd-devel
BuildRequires: libblkid-devel
BuildRequires: libssh-devel
%{?_enable_selinux:BuildRequires: libselinux-devel}
BuildRequires: /usr/bin/asciidoctor

%if "%default_crypto_backend" == "gcrypt"
# Need support for fixed gcrypt PBKDF2 and fixed Whirlpool hash.
BuildRequires: libgcrypt-devel >= 1.6.1
%endif
%if "%default_crypto_backend" == "openssl"
BuildRequires: libssl-devel >= 0.9.8
%endif
%if "%default_crypto_backend" == "nss"
BuildRequires: libnss-devel
%endif
%if "%default_crypto_backend" == "nettle"
BuildRequires: libnettle-devel
%endif
# for tests
BuildRequires: /proc

# Rename package from cryptsetup-luks-1.0.6-alt0.pre2 to cryptsetup-1.0.6-alt1
Provides:  cryptsetup-luks = %version
Obsoletes: cryptsetup-luks < %version-%release
Provides:  cryptsetup-veritysetup = %version
Obsoletes: cryptsetup-veritysetup < %version-%release
Provides:  cryptsetup-reencrypt = %version
Obsoletes: cryptsetup-reencrypt < %version-%release

%description
LUKS ( Linux Unified Key Setup ) is the upcoming standard for
Linux disk encryption. By providing a standard on-disk-format,
it does not only facilitate compatibility among distributions,
but also provide secure management of multiple user passwords.
In contrast to existing solution,  LUKS stores all  necessary
setup information  in the partition header, enabling the user
to transport or migrate his data seamlessly.

This package contains cryptsetup utility to setup a encrypted
disks based on  dm-crypt  module for 2.6 kernel, with support
for LUKS infrastructure. Also cryptsetup can handle old 2.4.x
cryptoloop devices.

%description -l ru_RU.UTF-8
LUKS ( Linux Unified Key Setup ) - разрабатываемый стандарт
для шифрования дисков в Linux. Определяя стандартный формат
хранения  информации на дисках,  он не только  способствует
совместимости  между различными  дистрибутивами,  но  также
предоставляет возможность управлять безопасностью доступа к
данным  путём  использования  нескольких   пользовательских
паролей. По сравнению с существующими решениями, в LUKS вся
необходимая  информация по  настройке параметров шифрования
хранится в заголовке  раздела диска, облегчая пользователям
перемещение или миграцию данных.

Данный пакет содержит  утилиту  cryptsetup  для  управления
зашифрованными  дисками, основанными на модуле dm-crypt для
ядер Linux 2.6.x,  с поддержкой  инфраструктуры LUKS. Также
cryptsetup может  управлять старыми дисками,  использующими
модуль cryptoloop ядер 2.4.x.

%package -n lib%name
Group: System/Libraries
Summary: Cryptsetup shared library
# Need support for fixed gcrypt PBKDF2 and fixed Whirlpool hash.
Requires: libgcrypt >= 1.6.1

%description -n lib%name
This package contains the cryptsetup shared library, libcryptsetup.

%package -n lib%name-devel
Summary: development files for cryptsetup-luks
Summary(ru_RU.UTF-8): файлы для разработки программ с использованием cryptsetup-luks
Group: Development/C
Requires: lib%name = %version-%release
Provides:  %name-devel = %version-%release
Obsoletes: %name-devel < %version-%release

%description -n lib%name-devel
LUKS ( Linux Unified Key Setup ) is the upcoming standard for
Linux disk encryption. By providing a standard on-disk-format,
it does not only facilitate compatibility among distributions,
but also provide secure management of multiple user passwords.
In contrast to existing solution,  LUKS stores all  necessary
setup information  in the partition header, enabling the user
to transport or migrate his data seamlessly.

This package includes  the  development libraries  and header
files needed for developing applications  that use LUKS.  You
need it only  if  You  plan to  develop or  compile some LUKS
applications.

%description -n lib%name-devel -l ru_RU.UTF-8
LUKS ( Linux Unified Key Setup ) - разрабатываемый стандарт
для шифрования дисков в Linux. Определяя стандартный формат
хранения  информации на дисках,  он не только  способствует
совместимости  между различными  дистрибутивами,  но  также
предоставляет возможность управлять безопасностью доступа к
данным  путём  использования  нескольких   пользовательских
паролей. По сравнению с существующими решениями, в LUKS вся
необходимая  информация по  настройке параметров шифрования
хранится в заголовке  раздела диска, облегчая пользователям
перемещение или миграцию данных.

Данный  пакет  содержит  библиотеки  и  заголовочные  файлы,
необходимые для разработки использующих LUKS приложений.  Он
необходим Вам  только  если Вы планируете  разрабатывать или
компилировать какие-либо приложения с поддержкой LUKS.

%package ssh-token
Summary: Cryptsetup LUKS2 SSH token
Group: System/Kernel and hardware
Requires: lib%name = %version-%release

%description ssh-token
This package contains the LUKS2 SSH token.

%prep
%setup -n %name-%version -a2
%patch0 -p1

cp -- %SOURCE1 README.ALT.utf-8

# Replacing license file with reference
mv -f -- COPYING COPYING.orig
ln -s -- $(relative %_licensedir/GPL-2 %_docdir/%name/COPYING) COPYING

%build
%autoreconf
%configure \
    --with-crypto_backend=%default_crypto_backend \
    --with-default-luks-format=%default_luks_format \
    --disable-internal-argon2 \
    --enable-libargon2 \
    --enable-passwdqc=/etc/passwdqc.conf

%make

#%meson \
#    -Dargon-implementation=libargon2 \
#    -Dcrypto-backend=%default_crypto_backend \
#    -Ddefault-luks-format=%default_luks_format \
#    -Ddefault-luks2-lock-dir-perms=0700 \
#    -Dpasswdqc=/etc/passwdqc.conf

#%meson_build

gcc debian/askpass.c -o debian/askpass

%install
%makeinstall_std
#%meson_install

install -Dpm 755 debian/cryptdisks-early.init %buildroot%_sysconfdir/rc.d/scripts/cryptdisks-early
install -Dpm 755 debian/cryptdisks.init %buildroot%_sysconfdir/rc.d/scripts/cryptdisks
mkdir -p %buildroot%_libdir/%name
install -Dpm 644 debian/cryptdisks.functions %buildroot%_sysconfdir/rc.d/init.d/cryptdisks.functions
install -Dpm 600 debian/cryptdisks.default %buildroot%_sysconfdir/sysconfig/cryptdisks
mkdir -p %buildroot%_libdir/%name/checks
install -Dpm 755 debian/checks/blkid %buildroot%_libdir/%name/checks/blkid
install -Dpm 755 debian/checks/un_blkid %buildroot%_libdir/%name/checks/un_blkid
install -Dpm 755 debian/askpass %buildroot%_libdir/%name/askpass

rm -rf %buildroot%_libdir/*.la
rm -rf %buildroot%_libdir/%name/*.la

%find_lang %name

%check
%make check
#export LD_LIBRARY_PATH=$(pwd)/%{__builddir}/src/shared:$(pwd)/%{__builddir}
#%meson_test

%files -f %name.lang
%doc docs/*
%doc AUTHORS FAQ.md README.md
%doc --no-dereference COPYING
%doc README.ALT.utf-8
%_sbindir/*
%exclude %_sbindir/cryptsetup-ssh
%_man8dir/*
%exclude %_man8dir/cryptsetup-ssh.*
%attr(600,root,root) %config(noreplace) %_sysconfdir/sysconfig/cryptdisks
%_sysconfdir/rc.d/scripts/cryptdisks-early
%_sysconfdir/rc.d/scripts/cryptdisks
%dir %_libdir/%name
%_sysconfdir/rc.d/init.d/cryptdisks.functions
%_libdir/%name/askpass
%dir %_libdir/%name/checks
%_libdir/%name/checks/*
%_tmpfilesdir/cryptsetup.conf

%files -n lib%name
%doc --no-dereference COPYING
%_libdir/lib%name.so.*
%dir %_libdir/%name

%files -n lib%name-devel
%_includedir/lib%name.h
%_libdir/lib%name.so
%_pkgconfigdir/*

%files ssh-token
%doc --no-dereference COPYING
%_libdir/%name/libcryptsetup-token-ssh.so
%_man8dir/cryptsetup-ssh.*
%_sbindir/cryptsetup-ssh

%changelog
