# FIXME
%define optflags_lto %nil
%ifnarch ppc64le loongarch64
%define with_amdgpu 1
%define with_cuda 1
%endif
%define _unpackaged_files_terminate_build 1

Name: criu
Version: 4.2
Release: alt1

Summary: Utility to checkpoint/restore tasks
License: GPL-2.0-only
Group: System/Configuration/Other
Url: http://criu.org

VCS: git://github.com/checkpoint-restore/criu.git
Source: %name-%version.tar
# Source1: criu.watch
# git://git.altlinux.org/gears/c/%%name.git
Source2: criu-tmpfiles.conf
Patch: %name-%version.patch

Obsoletes: crtools < %EVR
ExclusiveArch: x86_64 aarch64 ppc64le loongarch64

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-protobuf
BuildRequires: python3(pip)
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)
BuildRequires: python3(yaml)

BuildRequires: glibc-devel
BuildRequires: libaio-devel
BuildRequires: libnl-devel
BuildRequires: libcap-devel
BuildRequires: libselinux-devel
BuildRequires: libnet2-devel
BuildRequires: pkgconfig(protobuf)
BuildRequires: libprotobuf-c-devel %_bindir/protoc-c
BuildRequires: libprotobuf-devel protobuf-compiler
BuildRequires: asciidoc xmlto %_bindir/a2x
BuildRequires: libnftables-devel
BuildRequires: libgnutls-devel
BuildRequires: libbsd-devel
BuildRequires: libuuid-devel
BuildRequires: git

%ifdef with_amdgpu
BuildRequires: libdrm-devel
%endif

%description
An utility to checkpoint/restore tasks.

%package -n libcriu2
Summary: Shared library of checkpoint/restore
Group: System/Libraries
License: LGPL-2.1-only
Provides: libcriu

%description -n libcriu2
Shared library of checkpoint/restore.

%package -n libcompel1
Summary: Compel library for CRIU
Group: System/Libraries
License: LGPL-2.1-only
Provides: libcompel

%description -n libcompel1
Compel library for CRIU.

%package -n libcriu-devel
Summary: Files for development with libcriu
Group: Development/C
Requires: libcriu
Requires: libcompel

%description -n libcriu-devel
Files for development with libcriu.

%package -n python3-module-criu
Summary: Python library of checkpoint/restore
Group: System/Libraries
BuildArch: noarch
Provides: crit = %EVR
Provides: python-module-criu
Obsoletes: crtools-pycriu
Obsoletes: python-module-criu

%add_python3_self_prov_path %buildroot%python3_sitelibdir_noarch/pycriu/images

%description -n python3-module-criu
Python library library of checkpoint/restore.

%package plugin-amdgpu
Summary: AMDGPU plugin for checkpoint/restore.
Group: System/Libraries

%description plugin-amdgpu
This package contains the AMDGPU ROCm support plugin for checkpoint/restore.

%package plugin-cuda
Summary: CUDA plugin for checkpoint/restore.
Group: System/Libraries

%description plugin-cuda
This package contains the CUDA support plugin for checkpoint/restore.

%prep
%setup -n criu-%version
%autopatch -p1

%build
# Upstream claims that stack protection break criu
# https://github.com/checkpoint-restore/criu/issues/1744#issuecomment-1031605370
%add_optflags -fno-stack-protector -fno-stack-clash-protection
export CFLAGS="%optflags"
%make_build \
%ifarch armh
	UNAME-M=armv7l \
%endif
	PREFIX=%prefix V=1 all docs

%install
export PIPFLAGS="--no-build-isolation --no-index --no-deps"
%makeinstall_std \
%ifarch armh
    UNAME-M=armv7l \
%endif
    PREFIX=%_prefix LIBDIR=%_libdir LIBEXECDIR=%_libexecdir SYSTEMDUNITDIR=%_unitdir PYTHON=%__python3

mkdir -p %buildroot%_tmpfilesdir
install -m 0644 %SOURCE2 %buildroot%_tmpfilesdir/%name.conf
install -d -m 0755 %buildroot/run/%name/

ln -s criu %buildroot%_sbindir/crtools
ln -s criu.8 %buildroot%_man8dir/crtools.8

find %buildroot -name 'lib*.a' -delete
%ifndef with_amdgpu
echo "Removing %buildroot%_man1dir/criu-amdgpu-plugin.1*"
rm -f %buildroot%_man1dir/criu-amdgpu-plugin.1*
%endif
%ifndef with_cuda
rm -f %buildroot%_libdir/criu/cuda_plugin.so
%endif

%files
%doc README.md COPYING CREDITS
%_tmpfilesdir/%name.conf
%_sbindir/criu
%_sbindir/criu-ns
%_sbindir/crtools
%_bindir/compel
%_libexecdir/criu
%_libexecdir/compel
%_man1dir/compel.1*
%_man8dir/criu.8*
%_man1dir/criu-ns.1*
%_man8dir/crtools.8*

%files -n python3-module-criu
%_bindir/crit
%python3_sitelibdir_noarch/crit
%python3_sitelibdir_noarch/pycriu
%python3_sitelibdir_noarch/crit-%version.dist-info/
%python3_sitelibdir_noarch/pycriu-%version.dist-info/
%_man1dir/crit.1*

%files -n libcriu2
%_libdir/libcriu.so.2*

%files -n libcompel1
%_libdir/libcompel.so.1*

%files -n libcriu-devel
%_includedir/criu
%_includedir/compel
%_libdir/*.so
%_pkgconfigdir/criu.pc

%ifdef with_amdgpu
%files plugin-amdgpu
%doc plugins/amdgpu/README.md
%_man1dir/criu-amdgpu-plugin.1*
%dir %_libdir/criu
%_libdir/criu/amdgpu_plugin.so
%endif

%ifdef with_cuda
%files plugin-cuda
%doc plugins/cuda/README.md
%dir %_libdir/criu
%_libdir/criu/cuda_plugin.so
%endif

%changelog
