# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict,unresolved=normal

Name:    crash
Version: 9.0.1
Release: alt1
Summary: Linux kernel crash utility
Group:   Development/Debuggers
License: GPL-3.0-only
Url:     https://crash-utility.github.io/
Vcs:     https://github.com/crash-utility/crash
# Docs:  https://crash-utility.github.io/crash_whitepaper.html
# Mailing list: https://www.redhat.com/archives/crash-utility/
# Extensions Url: https://crash-utility.github.io/extensions.html
# Extensions Vcs: https://github.com/crash-utility/crash-extensions.git

# Crash calls a lot of tools.
# Non essential requires: bzip2 file findutils gzip less xz
Requires: binutils

Source0: %name-%version.tar
Source1: https://ftp.gnu.org/gnu/gdb/gdb-16.2.tar.gz

ExcludeArch: e2k
BuildRequires(pre): kernel-%kernel_latest
BuildRequires(pre): rpm-build-kernel
BuildRequires: flex
BuildRequires: gcc-c++
BuildRequires: libgmp-devel
BuildRequires: libmpfr-devel
BuildRequires: makeinfo
BuildRequires: ncurses-devel
BuildRequires: zlib-devel

%description
The core analysis suite is a self-contained tool that can be used to
investigate either live systems, kernel core dumps created from dump
creation facilities.

Whitepaper: https://crash-utility.github.io/crash_whitepaper.html

Note: You will need -debuginfo package for the current kernel installed
      for this tool to work!

%package -n kernel-ci-crash-debuginfo
Summary: CI test for %name
Group: Development/Other
Requires(post): crash = %EVR
Requires(post): rpm-build-vm
Requires(post): %(rpm -qa 'kernel-image-*' --qf '%%{NAME}-debuginfo' | grep . || echo unknown)

%description -n kernel-ci-crash-debuginfo
%summary with a workaround for 'sisyphus_check: check-deps ERROR: package
dependencies violation' for a kernel-image.

%prep
%setup
install -m644 %SOURCE1 .
mv crash-extensions/*.c extensions/
tar xvf crash-extensions/crash-gcore-command-1.6.1.tar.gz -C extensions --strip-components=1
tar xvf crash-extensions/ptdump-1.0.7.tar.gz -C extensions --strip-components=1

%build
%define optflags_lto %nil
%add_optflags $(getconf LFS_CFLAGS)
%make_build RPMPKG=%version-%release CFLAGS="%optflags" CXXFLAGS="%optflags" V=1
# Build what builds. Does not support -j.
%make -ki extensions

%install
%makeinstall_std
install -Dp -m0644 crash.8 %buildroot%_man8dir/crash.8
install -Dp -m0644 defs.h  %buildroot%_includedir/crash/defs.h
mkdir -p %buildroot%_libdir/crash/extensions
install -p -m0644 extensions/*.so %buildroot%_libdir/crash/extensions

%ifnarch armh
# armh: crash: cannot find a live memory device
#       due to no PROC_KCORE support on arm.
%post -n kernel-ci-crash-debuginfo
set -exu
%ifarch %ix86
KVER=$(cd /lib/modules; ls | head -1)
echo -e "6.6\n$KVER" | sort -CV || {
	# WARNING: could not find MAGIC_START!
	# WARNING: cannot read linux_banner string
	echo >&2 "Linux $KVER is too old for %_arch (skipping test)."
	exit 0
}
%endif
vm-run --kvm=only --heredoc <<-EOF1
	crash <<EOF2 |& tee crash.log
	ps
	exit
	EOF2
EOF1
grep 'KERNEL: /usr/lib/debug/.*lib/modules/.*/vmlinux' crash.log
grep 'DUMPFILE: /proc/kcore' crash.log
grep -F '[swapper/0]' crash.log
rm crash.log
rm -f /tmp/initramfs-*.img /tmp/vm.*
%endif

%files
%doc README COPYING3
%_bindir/crash
%_includedir/crash
%_man8dir/crash.8*
%_libdir/crash

%files -n kernel-ci-crash-debuginfo

%changelog
