%def_disable snapshot
%define ver_major 1.0
%define beta .beta.6

%def_disable bootstrap
%def_enable check

Name: cosmic-randr
Version: %ver_major.0
Release: alt0.81%beta

Summary: COSMIC RandR
License: MPL-2.0
Group: Graphical desktop/Other
Url: https://github.com/pop-os/cosmic-randr

Vcs: https://github.com/pop-os/cosmic-randr.git

%define git_ver epoch-%version%(echo %beta|sed 's/^\./-/')
%if_disabled snapshot
Source: %url/archive/%git_ver/%name-%version%beta.tar.gz
%else
Source: %name-%version%beta.tar
%endif
Source1: %name-%version%beta-cargo.tar

BuildRequires(pre): rpm-build-rust
BuildRequires: just

#ExcludeArch: %ix86 armh

%description
COSMIC RandR is both a library and command line utility for displaying
and configuring Wayland outputs. Each display is represented as an
"output head", whereas all supported configurations for each display is
represented as "output modes".

%prep
%setup -n %name-%{?_enable_snapshot:%version%beta}%{?_disable_snapshot:%git_ver} %{?_disable_bootstrap:-a1}
%{?_enable_bootstrap:
[ ! -d .cargo ] && mkdir .cargo
cargo vendor | sed 's/^directory = ".*"/directory = "vendor"/g' > .cargo/config.toml
tar -cf %_sourcedir/%name-%version%beta-cargo.tar .cargo/ vendor/}

%build
%rust_build

%install
just rootdir=%buildroot install

%check
%rust_test

%files
%_bindir/%name
%doc README*

%changelog
