%def_disable snapshot
%define ver_major 1.0
%define beta .beta.6
%define rdn_name com.system76.CosmicGreeter

%def_disable bootstrap
%def_enable check

Name: cosmic-greeter
Version: %ver_major.0
Release: alt0.81%beta

Summary: COSMIC Greeter
License: GPL-3.0
Group: Graphical desktop/Other
Url: https://github.com/pop-os/cosmic-greeter

Vcs: https://github.com/pop-os/cosmic-greeter.git

%define git_ver epoch-%version%(echo %beta|sed 's/^\./-/')
%if_disabled snapshot
Source: %url/archive/%git_ver/%name-%version%beta.tar.gz
%else
Source: %name-%version%beta.tar
%endif
Source1: %name-%version%beta-cargo.tar

Requires: greetd
Requires: cosmic-comp cosmic-randr
Provides: greetd-greeter

BuildRequires(pre): rpm-build-rust rpm-macros-pam0
BuildRequires: just clang-devel
BuildRequires: pkgconfig(xkbcommon)
BuildRequires: pkgconfig(libudev)
BuildRequires: pkgconfig(libinput)
BuildRequires: pkgconfig(pam)

# no cosmic-comp for ppc64le
ExcludeArch: %ix86 armh ppc64le

%description
COSMIC greeter for greetd, which can be run inside cosmic-comp.

%prep
%setup -n %name-%{?_enable_snapshot:%version%beta}%{?_disable_snapshot:%git_ver} %{?_disable_bootstrap:-a1}
%{?_enable_bootstrap:
[ ! -d .cargo ] && mkdir .cargo
cargo vendor | sed 's/^directory = ".*"/directory = "vendor"/g' > .cargo/config.toml
tar -cf %_sourcedir/%name-%version%beta-cargo.tar .cargo/ vendor/}

%build
export VERGEN_GIT_SHA=%version
export VERGEN_GIT_COMMIT_DATE=%(date --iso-8601)
export RUSTFLAGS="${RUSTFLAGS} -g"
just build-release
#%rust_build

%install
export VERGEN_GIT_SHA=%version
export VERGEN_GIT_COMMIT_DATE=%(date --iso-8601)
just rootdir=%buildroot install

%check
export VERGEN_GIT_SHA=%version
export VERGEN_GIT_COMMIT_DATE=%(date --iso-8601)
%rust_test

%files
%_bindir/%name
%_bindir/%name-start
%_bindir/%name-daemon
%_sysusersdir/%name.conf
%_tmpfilesdir/%name.conf
%_datadir/dbus-1/system.d/%rdn_name.conf
%doc README*

%changelog
