%def_disable snapshot
%define ver_major 1.0
%define beta .beta.6
%define rdn_name com.system76.CosmicFiles

%def_disable bootstrap
%def_enable check

Name: cosmic-files
Version: %ver_major.0
Release: alt0.81%beta

Summary: COSMIC File Manager
License: GPL-3.0
Group: Graphical desktop/Other
Url: https://github.com/pop-os/cosmic-files

Vcs: https://github.com/pop-os/cosmic-files.git

%define git_ver epoch-%version%(echo %beta|sed 's/^\./-/')
%if_disabled snapshot
Source: %url/archive/%git_ver/%name-%version%beta.tar.gz
%else
Source: %name-%version%beta.tar
%endif
Source1: %name-%version%beta-cargo.tar
Patch1: %name-1.0.0-alt-no-vergen.patch

# rustc-LLVM ERROR: out of memory
# Allocation failed
ExcludeArch: %ix86 armh

Requires: cosmic-icons

BuildRequires(pre): rpm-build-rust
BuildRequires: just
BuildRequires: pkgconfig(gio-2.0)
BuildRequires: pkgconfig(xkbcommon)
BuildRequires: /usr/bin/appstreamcli /usr/bin/desktop-file-validate

%description
File manager for the COSMIC desktop environment.

%prep
%setup -n %name-%{?_enable_snapshot:%version%beta}%{?_disable_snapshot:%git_ver} %{?_disable_bootstrap:-a1}
#%%patch1
%{?_enable_bootstrap:
[ ! -d .cargo ] && mkdir .cargo
cargo vendor | sed 's/^directory = ".*"/directory = "vendor"/g' > .cargo/config.toml
tar -cf %_sourcedir/%name-%version%beta-cargo.tar .cargo/ vendor/}

%build
export VERGEN_GIT_SHA=%version
export VERGEN_GIT_COMMIT_DATE=%(date --iso-8601)
%rust_build
%rust_build --package %name-applet

%install
export VERGEN_GIT_SHA=%version
export VERGEN_GIT_COMMIT_DATE=%(date --iso-8601)
just rootdir=%buildroot install

%check
export VERGEN_GIT_SHA=%version
export VERGEN_GIT_COMMIT_DATE=%(date --iso-8601)
%rust_test

%files
%_bindir/%name
%_bindir/%name-applet
%_desktopdir/%rdn_name.desktop
%_datadir/metainfo/%rdn_name.metainfo.xml
%_iconsdir/hicolor/*/apps/*.svg
%doc README*

%changelog
