%def_disable snapshot
%define ver_major 1.0
%define beta .beta.6
%define rdn_name com.system76.Cosmic

%def_disable bootstrap
%def_enable check

Name: cosmic-comp
Version: %ver_major.0
Release: alt0.81%beta

Summary: COSMIC Wayland Compositor
License: GPL-3.0
Group: Graphical desktop/Other
Url: https://github.com/pop-os/cosmic-comp

Vcs: https://github.com/pop-os/cosmic-comp.git

%define git_ver epoch-%version%(echo %beta|sed 's/^\./-/')
%if_disabled snapshot
Source: %url/archive/%git_ver/%name-%version%beta.tar.gz
%else
Source: %name-%version%beta.tar
%endif
Source1: %name-%version%beta-cargo.tar

ExcludeArch: %ix86 armh ppc64le

BuildRequires(pre): rpm-build-rust
BuildRequires: make
BuildRequires: pkgconfig(xkbcommon)
BuildRequires: pkgconfig(libudev)
BuildRequires: pkgconfig(libseat)
BuildRequires: pkgconfig(libinput)
BuildRequires: pkgconfig(pixman-1)
BuildRequires: pkgconfig(gbm)
BuildRequires: pkgconfig(libdisplay-info)

%description
Wayland compositor for the COSMIC desktop environment.

%prep
%setup -n %name-%{?_enable_snapshot:%version%beta}%{?_disable_snapshot:%git_ver} %{?_disable_bootstrap:-a1}
%{?_enable_bootstrap:
[ ! -d .cargo ] && mkdir .cargo
cargo vendor | sed 's/^directory = ".*"/directory = "vendor"/g' > .cargo/config.toml
tar -cf %_sourcedir/%name-%version%beta-cargo.tar .cargo/ vendor/}

%build
%rust_build

%install
%makeinstall_std prefix=%_prefix

%check
%rust_test

%files
%_bindir/%name
%_datadir/cosmic/com.system76.CosmicSettings.Shortcuts/v1/defaults
%_datadir/cosmic/com.system76.CosmicSettings.WindowRules/v1/tiling_exception_defaults

%changelog
