%def_enable watchdog
%def_enable monitoring
%def_enable snmp
%def_enable dbus
%def_enable systemd
%def_enable xmlconf
%def_enable augeas
%def_enable nozzle
%def_enable vqsim
%define _localstatedir %_var

Name: corosync
Version: 3.1.10
Release: alt1
Summary: The Corosync Cluster Engine and Application Programming Interfaces
License: BSD
Group: System/Base

Url: http://corosync.github.io/corosync/

Vcs: https://github.com/corosync/corosync.git
Source0: %name-%version.tar
Source1: corosync-init
Source2: corosync-notifyd-init

Patch: %name-%version.patch

Provides: corosync2 = %version-%release
Obsoletes: corosync2 < %version-%release
Requires: lib%name = %version-%release
# NSS crypto plugin should be always installed
Requires: libknet1-crypto-nss-plugin
# Support crypto reload
Requires: libknet1 >= 1.18

BuildRequires: doxygen libqb-devel graphviz libsocket-devel zlib-devel
BuildRequires: libknet-devel >= 1.18
%{?_enable_monitoring:BuildRequires: libstatgrab-devel}
%{?_enable_snmp:BuildRequires: libnet-snmp-devel}
%{?_enable_dbus:BuildRequires: libdbus-devel}
%{?_enable_nozzle:BuildRequires: libnozzle-devel}
%{?_enable_systemd:BuildRequires: systemd-devel}
%{?_enable_xmlconf:BuildRequires: libxslt-devel}
%{?_enable_augeas:BuildRequires: augeas libaugeas-devel}
%{?_enable_vqsim:BuildRequires: libreadline-devel}

%description
This package contains the Corosync Cluster Engine Executive, several
default APIs and libraries, default configuration files, and an init
script.

%package -n lib%name
Summary: The Corosync Cluster Engine Libraries
Group: System/Libraries
Conflicts: libcorosync
Provides: libcorosync2 = %version-%release
Obsoletes: libcorosync2 < %version-%release

%description -n lib%name
This package contains corosync libraries.

%package -n lib%name-devel
Summary: The Corosync Cluster Engine Development Kit
Group: Development/C
Requires: lib%name = %version-%release
Provides: libcorosync2-devel = %version-%release
Obsoletes: libcorosync2-devel < %version-%release

%description -n lib%name-devel
This package contains include files and man pages used to develop using
The Corosync Cluster Engine APIs.

%package vqsim
Summary: The Corosync Cluster Engine - Votequorum Simulator
Group: System/Base

%description vqsim
A command-line simulator for the corosync votequorum subsystem.
It uses the same code as the corosync quorum system but forks
them into subprocesses to simulate nodes.
Nodes can be added and removed as well as partitioned (to simulate
network splits)

%prep
%setup
%patch -p1

echo %version > .version
#if release version (= tarball)
#in checked-out repository it uses git describe
cp .version .tarball-version
mkdir -p m4

%build
%autoreconf
export BASHPATH=/bin/bash

%configure \
	%{subst_enable watchdog} \
	%{subst_enable monitoring} \
	%{subst_enable snmp} \
	%{subst_enable dbus} \
	%{subst_enable systemd} \
	%{subst_enable xmlconf} \
	%{subst_enable augeas} \
	%{subst_enable nozzle} \
	%{subst_enable vqsim} \
	--with-systemddir=%_unitdir

%make_build

%install
%makeinstall_std
%makeinstall_std -C init
touch %buildroot%_sysconfdir/corosync/corosync.conf
%if_enabled dbus
install -p -D -m644 conf/corosync-signals.conf %buildroot%_datadir/dbus-1/system.d/corosync-signals.conf
%endif

#Initscripts
install -p -D -m755 %SOURCE1 %buildroot%_initdir/corosync
install -p -D -m755 %SOURCE2 %buildroot%_initdir/corosync-notifyd

## tree fixup
# drop static libs
rm -f %buildroot%_libdir/*.a
# drop docs and html docs for now
rm -rf %buildroot%_docdir/*

mkdir -p %buildroot%_sysconfdir/sysconfig

# /etc/sysconfig/corosync-notifyd
install -p -m 644 tools/corosync-notifyd.sysconfig.example %buildroot%_sysconfdir/sysconfig/corosync-notifyd
# /etc/sysconfig/corosync
install -p -m 644 init/corosync.sysconfig.example %buildroot%_sysconfdir/sysconfig/corosync

rm -f %buildroot%_sysconfdir/corosync/corosync.conf.example
ln -r -s \
    %buildroot%_defaultdocdir/%name-%version/corosync.conf.example \
    %buildroot%_sysconfdir/corosync/corosync.conf.example

%check
%make check

%post
%post_service corosync
%post_service corosync-notifyd

%preun
%preun_service corosync
%preun_service corosync-notifyd

%files
%doc AUTHORS README* LICENSE conf/corosync.conf.example
%_bindir/*
%_sbindir/*
%dir %_sysconfdir/corosync
%dir %_sysconfdir/corosync/service.d
%dir %_sysconfdir/corosync/uidgid.d
%ghost %config(noreplace) %_sysconfdir/corosync/corosync.conf
%_sysconfdir/corosync/corosync.conf.example
%config(noreplace) %_sysconfdir/sysconfig/corosync-notifyd
%config(noreplace) %_sysconfdir/sysconfig/corosync
%config(noreplace) %_logrotatedir/corosync
%_unitdir/corosync.service
%_unitdir/corosync-notifyd.service
%if_enabled dbus
%_datadir/dbus-1/system.d/corosync-signals.conf
%endif
%_initrddir/corosync
%_initrddir/corosync-notifyd
%_datadir/corosync
%_datadir/snmp/mibs/COROSYNC-MIB.txt
%if_enabled augeas
%_datadir/augeas/lenses/*
%endif
%dir %_localstatedir/lib/corosync
%attr(750, root, adm) %_logdir/cluster
%_man5dir/*
%_man7dir/*
%_man8dir/*

%if_enabled vqsim
%exclude %_bindir/corosync-vqsim
%exclude %_man8dir/corosync-vqsim.8*
%endif

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/corosync
%_libdir/*.so
%_pkgconfigdir/*
%_man3dir/*

%if_enabled vqsim
%files vqsim
%doc LICENSE
%_bindir/corosync-vqsim
%_man8dir/corosync-vqsim.8*
%endif

%changelog
