%global import_path github.com/containerd/containerd

%global __find_debuginfo_files %nil
%global _unpackaged_files_terminate_build 1

%global commit      1c4457e00facac03ce1d75f7b6777a7a851e5c41
%global shortcommit %(c=%{commit}; echo ${c:0:7})

%set_verify_elf_method unresolved=no
%add_debuginfo_skiplist %_bindir
%brp_strip_none %_bindir/*

Name:		containerd
Version:	2.2.0
Release:	alt1
Summary:	A daemon to control runC

Group:		Development/Other
License:	Apache-2.0
URL:		https://%import_path

Packager:	Alexey Gladkov <legion@altlinux.ru>

Source0: %name-%version.tar
Source2: %name.init
Source3: %name.limits
Source4: config.toml

ExclusiveArch: %go_arches

BuildRequires(pre): rpm-build-golang
BuildRequires: golang go-md2man
BuildRequires: libbtrfs-devel
BuildRequires: libseccomp-devel

Provides: docker-%name = %version-%release
Obsoletes: docker-%name <= 1.0.0

Requires: runc

%description
containerd is a daemon to control runC, built for performance and density.
containerd leverages runC's advanced features such as seccomp and user namespace
support as well as checkpoint and restore for cloning and live migration of containers.

%prep
%setup -q
sed -i 's|/usr/local/bin/containerd|/usr/bin/containerd|g' containerd.service

%build
export IMPORT_PATH="%import_path"
export GOPATH="%go_path:$PWD"

mkdir -p src/github.com/containerd
ln -rTsf $PWD src/github.com/containerd/containerd
pushd src/github.com/containerd/containerd
make VERSION=v%version REVISION=%shortcommit binaries man
popd

%install
install -d -m 0755 %buildroot%_bindir
install -p -m 0755 bin/* %buildroot%_bindir/

install -D -p -m 0644 man/containerd.8 %buildroot%_man8dir/containerd.8
install -D -p -m 0644 man/containerd-config.8 %buildroot%_man8dir/containerd-config.8
install -D -p -m 0644 man/ctr.8 %buildroot%_man8dir/ctr.8
install -D -p -m 0644 man/containerd-config.toml.5 %buildroot%_man5dir/containerd-config.toml.5

install -D -p -m 0644 containerd.service %buildroot%_unitdir/%name.service
install -D -p -m 0755 %SOURCE2 %buildroot%_initdir/%name
install -D -p -m 0644 %SOURCE3 %buildroot%_sysconfdir/sysconfig/limits.d/%name
install -p -D -m 0644 %SOURCE4 %buildroot%_sysconfdir/%name/config.toml

%post
%post_service %name

%preun
%preun_service %name

%files
%config(noreplace) %_sysconfdir/%name/config.toml
%_sysconfdir/sysconfig/limits.d/%name
%_bindir/*
%_initdir/%name
%_unitdir/%name.service
%_man5dir/*
%_man8dir/*

%changelog
