%define app_id com.vscodium.codium

Name:    codium
Version: 1.101.14098
Release: alt2

Summary: Visual Studio Code without MS branding/telemetry/licensing

License: MIT 
Group:   Development/Other
Url:     https://github.com/VSCodium/vscodium
Vcs:     https://github.com/VSCodium/vscodium

#Source0-url: https://github.com/VSCodium/vscodium/releases/download/%{version}/VSCodium-linux-x64-%{version}.tar.gz
Source0: %name-x64-%version.tar
#Source1-url: https://github.com/VSCodium/vscodium/releases/download/%{version}/VSCodium-linux-arm64-%{version}.tar.gz
Source1: %name-arm64-%version.tar

Source2: codium.desktop
Source3: codium.svg
Source4: %app_id.metainfo.xml
Source5: codium-url-handler.desktop

%set_verify_elf_method skip
%global __find_debuginfo_files %nil

%filter_from_requires /deepin-api/d
%filter_from_requires /enlightenment/d
%filter_from_requires /exo-utils/d
%filter_from_requires /kde-cli-tools/d
%filter_from_requires /gnustep-Backbone/d
%filter_from_requires /pcmanfm/d
%filter_from_requires /github-cli/d

BuildRequires: electron29
BuildRequires: libgio
BuildRequires: libnss
BuildRequires: libnspr
BuildRequires: libatk
BuildRequires: at-spi2-atk
BuildRequires: libcups
BuildRequires: libdbus
BuildRequires: libdrm
BuildRequires: libgtk+3
BuildRequires: libpango
BuildRequires: libcairo 
BuildRequires: libgdk-pixbuf
BuildRequires: libX11
BuildRequires: libXcomposite
BuildRequires: libXdamage
BuildRequires: libXext
BuildRequires: libXfixes
BuildRequires: libXrandr
BuildRequires: libgbm
BuildRequires: libexpat
BuildRequires: libxcb
BuildRequires: libxkbcommon
BuildRequires: libalsa
BuildRequires: libat-spi2-core
BuildRequires: libsecret
BuildRequires: libxkbfile
BuildRequires: patchelf

Provides: vscodium = %EVR

ExclusiveArch: x86_64 aarch64

%description
Community-driven, freely-licensed binary distribution of Microsoft's editor VSCode
without MS branding/telemetry/licensing.
Visual Studio Code is a new choice of tool that combines the simplicity
of a code editor with what developers need for the core edit-build-debug cycle.
See FAQ at https://code.visualstudio.com/docs/setup/linux .

%prep
%ifarch x86_64
    tar -xf %SOURCE0
%endif
%ifarch aarch64
    tar -xf %SOURCE1
%endif

%build
#

%install
mkdir -p %buildroot%_libdir/%name/
cp -r %_builddir/%name-*-%version/* %buildroot%_libdir/%name/

mkdir -p %buildroot%_bindir/
# set suid for chrome-sandbox to avoid a startup error
chmod 4711 %buildroot%_libdir/%name/chrome-sandbox
ln -rs %buildroot%_libdir/%name/bin/codium %buildroot/%_bindir/codium
ln -rs %buildroot%_libdir/%name/bin/codium %buildroot/%_bindir/vscodium

%ifarch aarch64
patchelf --set-interpreter /lib64/ld-linux-aarch64.so.1 %buildroot%_libdir/%name/chrome-sandbox
patchelf --set-interpreter /lib64/ld-linux-aarch64.so.1 %buildroot%_libdir/%name/codium
patchelf --set-interpreter /lib64/ld-linux-aarch64.so.1 %buildroot%_libdir/%name/bin/codium-tunnel
patchelf --set-interpreter /lib64/ld-linux-aarch64.so.1 %buildroot%_libdir/%name/chrome_crashpad_handler
%endif

install -m644 -D %SOURCE2 %buildroot%_desktopdir/%name.desktop
install -m644 -D %SOURCE5 %buildroot%_desktopdir/%name-url-handler.desktop
install -m644 -D %SOURCE3 %buildroot%_iconsdir/hicolor/scalable/apps/codium.svg
install -m644 -D %SOURCE4 %buildroot%_datadir/appdata/%app_id.metainfo.xml


%files
%_bindir/%name
%_bindir/vs%name
%_libdir/%name/
%_desktopdir/%name.desktop
%_desktopdir/%name-url-handler.desktop
%_iconsdir/hicolor/scalable/apps/codium.svg
%_datadir/appdata/%app_id.metainfo.xml

%changelog
