
%global import_path github.com/containernetworking/plugins
%global _unpackaged_files_terminate_build 1
%define _libexecdir /usr/libexec
%define cni_dir %_libexecdir/cni
%define cni_etc_dir %_sysconfdir/cni

Name: cni-plugins
Version: 1.8.0
Release: alt1
Summary: Container Network Interface plugins
Group: Development/Other
License: Apache-2.0
Url: https://%import_path
Source: %name-%version.tar
Source2: %name.tmpfiles
ExclusiveArch: %go_arches

Provides: containernetworking-plugins = %EVR
Provides: container-network-stack = 1
BuildRequires(pre): rpm-macros-golang
BuildRequires: rpm-build-golang golang >= 1.24.2
BuildRequires: /proc

%description
The CNI (Container Network Interface) project consists of a
specification and libraries for writing plugins to configure
network interfaces in Linux containers, along with a number of
supported plugins. CNI concerns itself only with network
connectivity of containers and removing allocated resources when
the container is deleted. Because of this focus, CNI has a wide
range of support and the specification is simple to implement.

These are the additional CNI network plugins provided by
the containernetworking team.

%prep
%setup -q

# Use correct paths in cni-dhcp unitfiles
sed -i 's,/opt/cni/bin,%cni_dir,' plugins/ipam/dhcp/systemd/cni-dhcp.service

%build
./build_linux.sh

%install
mkdir -p %buildroot{%cni_dir,%cni_etc_dir/net.d,%_unitdir,%_tmpfilesdir}
install -m0755 bin/* %buildroot%cni_dir/

install -p -m0644 plugins/ipam/dhcp/systemd/cni-dhcp.service %buildroot%_unitdir
install -p -m0644 plugins/ipam/dhcp/systemd/cni-dhcp.socket %buildroot%_unitdir
install -p -m0644 %SOURCE2 %buildroot%_tmpfilesdir/%name.conf

%post
%post_service cni-dhcp

%preun
%preun_service cni-dhcp

%files
%doc LICENSE README.md
%dir %cni_etc_dir
%dir %cni_etc_dir/net.d
%dir %cni_dir
%cni_dir/*
%_unitdir/*
%_tmpfilesdir/*

%changelog
