Name: clisp
Version: 2.49.92
Release: alt2.3
Epoch: 1

Summary: Common Lisp (ANSI CL) implementation
License: GPL
Group: Development/Lisp
Url: http://clisp.cons.org/

Source: %name-%version.tar

# core
BuildRequires: libsigsegv-devel libffcall-devel libreadline-devel libtinfo-devel
# modules
BuildRequires: libdb6-devel libgdbm-devel libpcre-devel postgresql-devel zlib-devel
BuildRequires: libX11-devel libXpm-devel libXext-devel libXau-devel
# check
BuildRequires: /proc /dev/pts

%description
Common Lisp is a high-level, general-purpose programming language.

GNU CLISP is a Common Lisp implementation by Bruno Haible of Karlsruhe
University and Michael Stoll of Munich University, both in Germany.
It mostly supports the Lisp described in the ANSI Common Lisp standard.
It runs on microcomputers (Windows NT/2000/XP, Windows 95/98/ME) as well
as on Unix workstations (Linux, SVR4, Sun4, DEC Alpha OSF, HP-UX, BeOS,
NeXTstep, SGI, AIX and others) and needs only 2 MB of RAM.

It is Free Software and may be distributed under the terms of GNU GPL,
while it is possible to distribute commercial applications compiled
with GNU CLISP.

The user interface comes in German, English, French, Spanish, Dutch,
Russian and Danish.

GNU CLISP includes an interpreter, a compiler, a debugger, CLOS,
a foreign language interface, sockets, i18n, fast bignums and more.
An X11 interface is available through CLX, Garnet, CLUE/CLIO.
GNU CLISP runs Maxima, ACL2 and many other Common Lisp packages.

%prep
%setup
cp -f /usr/share/autoconf/build-aux/config.{guess,sub} src/build-aux/

%build
sh configure --prefix=%prefix --libdir=%_libdir \
	--with-module=asdf \
	--with-module=berkeley-db \
	--with-module=clx/new-clx \
	--with-module=gdbm \
	--with-module=pcre \
	--with-module=postgresql \
	--with-module=rawsock \
	--with-module=zlib

%make_build

%install
%makeinstall_std
rm -vfr %buildroot%_libdir/clisp-%version/build-aux/

%find_lang --output=%name.lang --append clisp clisplow

%check
make check

%files -f %name.lang
%_docdir/%name-%version
%_bindir/clisp
%_bindir/clisp-link
%_libdir/clisp-%version
%_datadir/aclocal/clisp.m4
%_man1dir/*

%changelog
