%define gst_api_ver 1.0

Name: clementine
Version: 1.4.1.58
Release: alt1.gbae968a2f
Summary: A music player and library organiser

Group: Sound
License: GPL-3.0-or-later AND GPL-2.0-or-later AND BSL-1.0 AND LGPL-2.0-or-later AND LGPL-2.1-only AND Apache-2.0 AND (LGPL-2.1-only WITH Qt-LGPL-exception-1.1 OR GPL-3.0-only) AND (LGPL-2.1-only WITH Qt-LGPL-exception-1.1 OR LGPL-3.0-only WITH Qt-LGPL-exception-1.1) AND MIT

Url: https://www.clementine-player.org/

Source0: %name-%version.tar.gz
Patch1: 01-fix-cmake.patch
Patch2: 02-fix-version.patch

BuildRequires(pre): rpm-build-licenses
BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
BuildRequires: /proc
BuildRequires: boost-devel-headers gcc-c++
BuildRequires: libgio-devel libglew-devel libgpod-devel libmtp-devel
BuildRequires: libqt5-opengl libqt5-sql libqt5-webkit libqt5-xmlpatterns qt5-x11extras-devel
BuildRequires: libtag-devel
BuildRequires: gstreamer%gst_api_ver-devel
BuildRequires: gst-plugins%gst_api_ver-devel
BuildRequires: gstreamer%gst_api_ver-utils
BuildRequires: pkgconfig(gstreamer-tag-%gst_api_ver)
BuildRequires: libchromaprint-devel
BuildRequires: libcryptopp-devel >= 6
# SQLITE_DBCONFIG_ENABLE_FTS3_TOKENIZER is available since 3.12
BuildRequires: libsqlite3-devel >= 3.12
BuildRequires: libpulseaudio-devel
BuildRequires: qt5-tools-devel
BuildRequires: libalsa-devel
BuildRequires: libfftw3-devel
BuildRequires: git
BuildRequires: libclastfm-devel

BuildRequires: protobuf-compiler
# Enable Google Drive support
BuildRequires: libgoogle-sparsehash
BuildRequires: libavcodec-devel libavformat-devel libpcre-devel
BuildRequires: libprotobuf-devel libcdio-devel
BuildRequires: pkgconfig(libdeflate)
BuildRequires: pkgconfig(libpcre2-8)
BuildRequires: pkgconfig(blkid)
BuildRequires: pkgconfig(bzip2)
BuildRequires: pkgconfig(expat)
BuildRequires: pkgconfig(mount)
BuildRequires: pkgconfig(libbrotlidec)
BuildRequires: pkgconfig(libffi)
BuildRequires: pkgconfig(libjpeg)
BuildRequires: pkgconfig(libtiff-4)
BuildRequires: pkgconfig(libusb-1.0)
BuildRequires: pkgconfig(libwebp)
BuildRequires: pkgconfig(libxml-2.0)
BuildRequires: pkgconfig(liblzma)
BuildRequires: pkgconfig(libzstd)
BuildRequires: liborc-devel
# Check:
BuildRequires: %_bindir/appstream-util desktop-file-utils

# Clementine crashes without it
Requires: gst-plugins-base%gst_api_ver
Requires: gst-plugins-good%gst_api_ver
Requires: icon-theme-hicolor

%description
Clementine is a modern music player and library organiser.
It is inspired by Amarok 1.4, focusing on a fast and easy-to-use interface for
searching and playing your music.

Features include:
  * Search and play your local music library
  * Listen to internet radio from Last.fm, SomaFM, IntergalacticFM, Magnatune,
    Jamendo and Icecast
  * Create smart playlists and dynamic playlists
  * Tabbed playlists, import and export M3U, XSPF, PLS and ASX
  * Visualisations from projectM
  * Lyrics and artist biographies and photos
  * Transcode music into MP3, Ogg Vorbis, Ogg Speex, FLAC or AAC
  * Edit tags on MP3 and OGG files, organise your music
  * Download missing album cover art from Last.fm
  * Cross-platform - works on Windows, Mac OS X and Linux
  * Native desktop notifications on Linux (libnotify) and Mac OS X (Growl)
  * Remote control using a Wii Remote, MPRIS or the command-line
  * Copy music to your iPod, iPhone, MTP or mass-storage USB player
  * Queue manager

%add_python_req_skip clementine

%prep
%setup
%autopatch -p2
%ifarch %e2k
%add_optflags -Winvalid-offsetof
sed -i "s|== Separator|== QChar(Separator)|" \
	ext/libclementine-tagreader/fmpsparser.cpp
%endif
sed -i 's|local_server_name_ = qApp->applicationName().toLower();|local_server_name_ = QString(qApp->applicationName()).toLower();|' \
	ext/libclementine-common/core/workerpool.h

if [ ! -d .git ]; then
    git init
    git config user.email author@example.com
    git config user.name author
    git add .
    git commit -m 'release'
    git tag -a '%version' -m '%version'
fi

%build
%cmake -DBUNDLE_PROJECTM_PRESETS=ON \
       -DFORCE_GIT_REVISION=%version.%release \
       -DBUILD_WERROR:BOOL=OFF \
       -DCMAKE_BUILD_TYPE:STRING=Release \
       -DCMAKE_CXX_STANDARD:INT=17 \
       -DCMAKE_POSITION_INDEPENDENT_CODE:BOOL=ON \
       -DUSE_SYSTEM_TAGLIB:BOOL=ON \
       -Wno-dev
%cmake_build

%install
%cmakeinstall_std
%find_lang --with-kde %name

%check
desktop-file-validate %buildroot%_desktopdir/org.clementine_player.Clementine.desktop
appstream-util validate-relax --nonet %buildroot%_datadir/metainfo/org.clementine_player.Clementine.appdata.xml

%files -f %name.lang
%doc COPYING Changelog
%_bindir/clementine
%_bindir/clementine-tagreader
%_desktopdir/org.clementine_player.Clementine.desktop
%_datadir/kservices5/*.protocol
%_datadir/clementine
%_datadir/metainfo/org.clementine_player.Clementine.appdata.xml
%_datadir/icons/hicolor/*/apps/*.png
%_datadir/icons/hicolor/*/apps/*.svg


%changelog
