# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

%def_disable gtk_doc

Name: cinnamon
Version: 6.4.13
Release: alt1

Summary: A Linux desktop which provides advanced innovative features and a traditional user experience.
License: GPL-2.0-or-later
Group: Graphical desktop/GNOME

URL: https://github.com/linuxmint/cinnamon
VCS: https://github.com/linuxmint/cinnamon.git

Source0: %name-%version.tar
Source1: polkit-%name-authentication-agent-1.desktop

Patch: %name-%version-%release.patch

%add_python3_path %_datadir/%name
%set_typelibdir %_libdir/%name

%define gtk_ver 3.12.0
%define gi_ver 0.10.1
%define muffin_ver 4.0.3
%define json_glib_ver 0.13.2
%define cjs_ver 4.0.0
%define polkit_ver 0.100
%define folks_ver 0.5.2
%define bt_ver 3.0.0

Provides: desktop-notification-daemon
Provides: cinnamon-data = %EVR

Requires: dconf
Requires: upower
Requires: polkit >= %polkit_ver
Requires: polkit-gnome
# needed for on-screen keyboard
Requires: caribou
Requires: %name-data = %version-%release
Requires: muffin >= %muffin_ver
Requires: muffin-cinnamon >= %muffin_ver
Requires: libmuffin-gir >= %muffin_ver
Requires: %name-translations
Requires: gst-plugins-base1.0


# needed to install applets
Requires: gettext-tools

Obsoletes: %name-data < %EVR

BuildRequires(pre): rpm-build-gir >= 0.7.3
BuildPreReq: rpm-build-python3
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libcjs-devel >= %cjs_ver
BuildPreReq: libjson-glib-devel >= %json_glib_ver
BuildRequires: meson
BuildRequires: gcc-c++
BuildRequires: libcinnamon-desktop-devel libgnome-keyring-devel libcinnamon-menus-devel
BuildRequires: libstartup-notification-devel libcinnamon-desktop-gir-devel
BuildRequires: libpolkit-devel libupower-devel libgudev-devel libnm-devel libnm-gir-devel
BuildRequires: libcanberra-gtk3-devel
BuildRequires: gobject-introspection >= %gi_ver libupower-gir-devel libgudev-gir-devel
BuildRequires: libcinnamon-menus-gir-devel
BuildRequires: gst-plugins1.0-devel
BuildRequires: pkgconfig(libxml-2.0)
BuildRequires: libpolkit-gir-devel
BuildRequires: pkgconfig(gcr-base-3)
BuildRequires: pkgconfig(libsecret-1)
BuildRequires: %_bindir/pysassc
BuildRequires: gcr-libs-gir-devel

# for barriers
BuildRequires: libXfixes-devel >= 5.0
# used in unused BigThemeImage
BuildRequires: librsvg-devel
BuildRequires: libmuffin-devel >= %muffin_ver
BuildRequires: libmuffin-gir-devel >= %muffin_ver
BuildRequires: libdrm-devel libgbm-devel
BuildRequires: libpulseaudio-devel

BuildRequires: desktop-file-utils
BuildRequires: gtk-doc gnome-common intltool
BuildRequires: at-spi2-atk-devel
BuildRequires: rpm-build-xdg
BuildRequires: libxapps-devel libxapps-gir-devel

# @cow: In https://bugzilla.altlinux.org/42722 we decided to move cinnamon-minimal
# deps to cinnamon package because there are cases reported when users tried to
# install cinnamon DE not using the meta package but cinnamon package instead.
Provides: cinnamon-minimal = %version-%release
Obsoletes: cinnamon-minimal < 5.6
Requires: cinnamon-session > 6.0.0
Requires: nemo
Requires: cinnamon-screensaver
Requires: cinnamon-control-center
Requires: mintlocale
Requires: cinnamon-freedesktop-menu
#Gvfs
Requires: gvfs gvfs-backends gvfs-utils
# Char map - required by cinnamon keyboard applet
Requires: gucharmap
Requires: xdg-desktop-portal-xapp
Requires: typelib(Gcr) = 3

Provides: python3(cme)
Provides: python3(Spices)
# https://bugzilla.altlinux.org/36995
Requires: python3-module-PAM
Requires: python3-module-xapps-overrides
# Required for xapp-status applet
Requires: xapp-sn-watcher
# Required for cinnamon-settings info module
Requires: python3(distro)

%description
Cinnamon is a Linux desktop which provides advanced innovative features
and a traditional user experience.

The desktop layout is similar to Gnome 2. The underlying technology is
forked from Gnome Shell. The emphasis is put on making users feel at
home and providing them with an easy to use and comfortable desktop
experience.

%package devel-doc
Summary: Development doc package for Cinnamon
Group: Development/Documentation
BuildArch: noarch

%description devel-doc
Development docs package for Cinnamon.

%prep
%setup -n %name-%version
%patch -p1

rm -rf debian

%build
%meson --libexecdir=%{_libexecdir}/cinnamon
%meson_build

%install
%meson_install

#install polkit files
install -D -p -m 0644 %SOURCE1 %buildroot/%_datadir/applications/

# Clean-up requires

# cinnamon/files/usr/share/cinnamon/cinnamon-settings/modules/cs_themes.py
# from gi.repository.Gtk import SizeGroup, SizeGroupMode
%filter_from_requires /python3[(]gi.repository.Gtk[)]/d

# There is already registered upstream issue https://github.com/linuxmint/muffin/issues/199
# But untill it will be fixed by Cinnamon devs we handle it manually.
# Note: to handle dependency we require libmuffin-gir explicitly
%filter_from_requires /typelib(Meta)/d

# Another conflict with gnome-shell
%filter_from_requires /typelib(St)/d

# Remove from explicit dependencies muffin private libraries. By default
# RPM doesn't generate this provides for muffin but generates requires
# for them in cinnamon debuginfo packages.
%filter_from_requires /libmuffin-clutter/d
%filter_from_requires /libmuffin-cogl/d

# Clean-up provides
# gnome-shell provides typelib(St) as well
%filter_from_provides /typelib(St)/d

rm -f %buildroot/%_man1dir/cinnamon-session-cinnamon.1
rm -f %buildroot/%_man1dir/cinnamon-session-cinnamon2d.1

desktop-file-validate %buildroot%_desktopdir/cinnamon.desktop
desktop-file-validate %buildroot%_desktopdir/cinnamon2d.desktop
desktop-file-validate %buildroot%_desktopdir/cinnamon-wayland.desktop

%files
%exclude %_bindir/%{name}-launcher
%_bindir/*
%_libdir/cinnamon/
%_libexecdir/cinnamon/cinnamon-hotplug-sniffer
%_libexecdir/cinnamon/cinnamon-perf-helper
%_libexecdir/cinnamon/cinnamon-calendar-server.py
%exclude %_xdgmenusdir/cinnamon-applications-merged
%exclude %_xdgmenusdir/cinnamon-applications.menu
%exclude %_datadir/xsessions/*.desktop
%exclude %_datadir/wayland-sessions/*.desktop
%exclude %_datadir/cinnamon-session/sessions/*.session
%_datadir/xdg-desktop-portal/x-cinnamon-portals.conf
%_datadir/cinnamon/
%_datadir/dbus-1/services/org.Cinnamon.HotplugSniffer.service
%_datadir/dbus-1/services/org.Cinnamon.Melange.service
%_datadir/dbus-1/services/org.Cinnamon.Slideshow.service
%_datadir/dbus-1/services/org.cinnamon.CalendarServer.service
%_datadir/desktop-directories/*.directory
%_datadir/glib-2.0/schemas/*.xml
%_datadir/polkit-1/actions/org.cinnamon.settings-users.policy
%python3_sitelibdir_noarch/cinnamon/
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/*/*.svg
%_iconsdir/hicolor/*/*/*.png
%_man1dir/*.1.*

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/*
%endif

%changelog
