%def_with doc

Name: cifs-utils
Version: 7.3
Release: alt1

Summary: Utilities for doing and managing mounts of the Linux CIFS filesystem
License: GPLv3+
Group: System/Kernel and hardware

Url: https://wiki.samba.org/index.php/LinuxCIFS_utils
Source: %name-%version.tar

Patch3: cifs-utils-alt-docutils.patch

BuildRequires(pre): rpm-macros-pam0 rpm-macros-alternatives
BuildRequires: libcap-ng-devel libkeyutils-devel libkrb5-devel libtalloc-devel libwbclient-devel libpam-devel
BuildRequires: python3-module-docutils rpm-build-python3
Requires: keyutils
Conflicts: samba-client < 3.6.0-alt1

%description
This is the release version of cifs-utils, a package of utilities for
doing and managing mounts of the Linux CIFS filesystem. These programs
were originally part of Samba, but have now been split off into a
separate package.

%package devel
Summary: Files needed for building plugins for cifs-utils
Group: Development/C

%description devel
The SMB/CIFS protocol is a standard file sharing protocol widely deployed
on Microsoft Windows machines. This package contains the header file
necessary for building ID mapping plugins for cifs-utils.

%package -n pam_cifscreds
Summary: PAM module to manage NTLM credentials in kernel keyring
Group: System/Base

%description -n pam_cifscreds
The pam_cifscreds PAM module is a tool for automatically adding
credentials (username and password) for the purpose of establishing
sessions in multiuser mounts.

When a cifs filesystem is mounted with the "multiuser" option, and does
not use krb5 authentication, it needs to be able to get the credentials
for each user from somewhere. The pam_cifscreds module can be used to
provide these credentials to the kernel automatically at login.

%prep
%setup
%patch3 -p1

%build
%autoreconf
%configure \
	--with-pamdir=%_pam_modules_dir \
%if_with doc
	--enable-man \
%endif
	--enable-systemd \
	--enable-smbinfo \
	--enable-cifscreds \
	--enable-cifsacl \
	--enable-cifsidmap \
	--enable-cifsupcall \
	--with-idmap-plugin=%_libdir/%name/idmap-plugin
%make_build

%install
install -d %buildroot/sbin
%makeinstall_std
mkdir -p %buildroot%_sysconfdir/request-key.d
install -pm644 contrib/request-key.d/cifs.{idmap,spnego}.conf %buildroot%_sysconfdir/request-key.d/

# Add alternatives for idmap-plugin
mkdir -p %buildroot/%_altdir
printf '%_libdir/%name/idmap-plugin\t%_libdir/%name/idmapwb.so\t10\n' > %buildroot/%_altdir/cifs-idmap-plugin-idmapwb

%files
/sbin/mount.cifs
/sbin/mount.smb3
%_sbindir/cifs.upcall
%_sbindir/cifs.idmap
%_bindir/cifscreds
%_bindir/getcifsacl
%_bindir/setcifsacl
%_bindir/smb2-quota
%_bindir/smbinfo
%dir %_libdir/%name
%_libdir/%name/idmapwb.so
%_altdir/cifs-idmap-plugin-idmapwb
%if_with doc
%_man8dir/cifs.idmap.8*
%_man8dir/cifs.upcall.8*
%_man8dir/mount.cifs.8*
%_man8dir/mount.smb3.8*
%_man8dir/idmapwb.8.*
%_man1dir/getcifsacl.1*
%_man1dir/setcifsacl.1*
%_man1dir/cifscreds.1*
%_man1dir/smb2-quota.1*
%_man1dir/smbinfo.1*
%endif
%doc AUTHORS ChangeLog README
%config(noreplace) %_sysconfdir/request-key.d/cifs.idmap.conf
%config(noreplace) %_sysconfdir/request-key.d/cifs.spnego.conf

%files devel
%_includedir/*

%files -n pam_cifscreds
%_pam_modules_dir/pam_cifscreds.so
%if_with doc
%_man8dir/pam_cifscreds.*
%endif

%changelog
