%define optflags_lto %nil

Name: chafa
Version: 1.14.2
Release: alt1
%global sum     Image-to-text converter for terminal
Summary: %sum
License: LGPLv3+
Group: Graphics
Url: https://hpjansson.org/chafa/
Packager: Artyom Bystrov <arbars@altlinux.org>

Source: https://github.com/hpjansson/%name/releases/download/%version/%name-%version.tar.xz

BuildRequires: gcc
BuildRequires: glib2-devel
BuildRequires: gtk-doc
BuildRequires: ImageMagick-devel
BuildRequires: libtool
BuildRequires: make
BuildRequires: libfreetype-devel

Requires: %name-libs = %version-%release

%description
Chafa is a command-line utility that converts all kinds of images, including
animated image formats like GIFs, into ANSI/Unicode character output that can
be displayed in a terminal.

It is highly configurable, with support for alpha transparency and multiple
color modes and color spaces, combining a range of Unicode characters for
optimal output.

%package libs
Summary: %sum (library)
Group: Graphics
# Version in libnsgif/README-chafa
Provides: bundled(libnsgif) = 0.2.1-chafa
# Version in lodepng/lodepng.h
Provides: bundled(lodepng) = 20220109

%description libs
Shared library for %name.

%package static
Summary: %sum (static library)
Group: Development/C
%description static
Static library for %name.

%package devel
Summary: %sum (development files)
Requires: %name-libs%{?_isa} = %version-%release
Group: Development/C
%description devel
Development files for %name, such as headers.

%package doc
Summary: %sum (documentation)
Group: Development/Documentation
#Recommends:     %name-devel

%description doc
Documentation for %name, such as headers.

%prep
%setup

%build
autoreconf -ivf
%configure --disable-rpath
%make_build

%install
%makeinstall_std

%files
%doc AUTHORS COPYING.LESSER README* NEWS
%doc COPYING.LESSER
%_bindir/%name
%_man1dir/%name.1*

%files libs
%doc AUTHORS
%doc COPYING.LESSER
%_libdir/lib%name.so.0
%_libdir/lib%name.so.0.9.2

%files static
%doc AUTHORS
%doc COPYING.LESSER
%_libdir/lib%name.a

%files devel
%doc AUTHORS
%doc COPYING.LESSER
%_includedir/%name/
%_pkgconfigdir/%name.pc
%_libdir/lib%name.so
%_libdir/%name/include/chafaconfig.h

%files doc
%doc AUTHORS
%doc COPYING.LESSER

%changelog
