%define xdg_name io.github.celluloid_player.Celluloid

Name: celluloid
Version: 0.29
Release: alt1

Summary: Celluloid (formerly GNOME MPV) is a simple GTK+ frontend for mpv.
License: GPLv3
Group: Video

Url: https://github.com/celluloid-player/celluloid
Source: %name-%version.tar
Packager: Vladimir Didenko <cow@altlinux.org>

Provides: gnome-mpv = %version-%release
Obsoletes: gnome-mpv <= 0.16

BuildRequires: libappstream-glib-devel
BuildRequires: meson
BuildRequires: python3-dev
BuildRequires: glib2-devel
BuildRequires: libgtk4-devel
BuildRequires: libmpv-devel
BuildRequires: libepoxy-devel
BuildRequires: libadwaita-devel

Requires: yt-dlp

%description
Celluloid (formerly GNOME MPV) is a simple GTK+ frontend for mpv. Celluloid
interacts with mpv via the client API exported by libmpv, allowing access
to mpv's powerful playback capabilities.

%prep
%setup

%build
%meson
%meson_build

%install
%meson_install

%find_lang %name

%files -f %name.lang
%doc COPYING README.md
%_bindir/%name
%_datadir/metainfo/%xdg_name.appdata.xml
%_desktopdir/%xdg_name.desktop
%_datadir/glib-2.0/schemas/*
%_iconsdir/hicolor/*/apps/*.svg
%_datadir/dbus-1/services/%xdg_name.service
%_man1dir/*.1.*

%changelog
