# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: catfish
Version: 4.20.1
Release: alt1
Summary: A handy file search tool

Group: File tools
License: GPL-2.0-or-later
Url: https://gitlab.xfce.org/apps/catfish
# Source-url: https://gitlab.xfce.org/apps/catfish/-/archive/catfish-%version/catfish-catfish-%version.tar.gz
Source: %name-%version.tar.gz
BuildArch: noarch
Patch: catfish-%version-ALT-searchODF.patch

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson
BuildRequires: rpm-build-python3
#BuildRequires: intltool python3-dev python3-module-distutils-extra python3-module-pexpect python3-module-zeitgeist2.0
#BuildRequires: python3-module-pygobject3
BuildRequires: rpm-build-gir
BuildRequires: python3(dbus)
BuildRequires: python3(gi)
BuildRequires: python3(pexpect)
BuildRequires: pkgconfig(gdk-3.0)
BuildRequires: pkgconfig(libxfconf-0)

# search engine
Requires: %_bindir/locate
Requires: %_bindir/find
Requires: python3-module-catfish = %EVR

# XXX /etc/mime.types belongs here
Requires: mailcap

%description
A handy file search tool using different backends which is
configurable via the command line.

This program acts as a frontend for different file search engines.
The interface is intentionally lightweight and simple. But it takes
configuration options from the command line.

%package -n python3-module-catfish
Group: Development/Python3
Summary: Supplemental module for catfish

Requires: typelib(Gtk) = 3.0

%description -n python3-module-catfish
Supplemental Python3 module for catfish, a handy file search tool.

%prep
%setup -n %name-%version
%patch -p2

%build
%meson
%meson_build

%install
# XXX upstream cant' handle this :)
#install -D build/share/applications/*.desktop %buildroot/%_desktopdir/org.xfce.Catfish.desktop

%meson_install

rm -r %buildroot%_defaultdocdir/%name

# remove non-scallable icons
rm -vr %buildroot%_iconsdir/hicolor/*x*/

%find_lang catfish

%files -f catfish.lang
%doc AUTHORS COPYING README.md
%_bindir/catfish
%_desktopdir/org.xfce.Catfish.desktop
%_datadir/catfish
%_datadir/metainfo/catfish.appdata.xml
%_iconsdir/hicolor/scalable/apps/org.xfce.catfish.svg
%_man1dir/catfish.1.*

%files -n python3-module-catfish
%python3_sitelibdir_noarch/catfish
%python3_sitelibdir_noarch/catfish_lib

%changelog
