%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%global optflags_lto %optflags_lto -ffat-lto-objects

%define sover 5

Summary: Capstone disassembly/disassembler framework
Name: capstone
Version: 5.0.6
Release: alt1
License: BSD-3-Clause
Group: Development/Tools
Url: http://capstone-engine.org/
Vcs: https://github.com/capstone-engine/capstone

Source: %name-%version.tar

Requires: lib%name%sover = %EVR

BuildRequires(pre): rpm-macros-java
BuildRequires(pre): rpm-macros-python3
BuildRequires: java-devel-default
BuildRequires: jna
BuildRequires: /proc
BuildRequires: python-devel
BuildRequires: rpm-build-python3

%description
Capstone is a disassembly framework with the target of becoming the ultimate
disasm engine for binary analysis and reversing in the security community.

%package -n lib%name%sover
Summary: Capstone shared library
Group: System/Libraries
Obsoletes: capstone < %EVR
%description -n lib%name%sover
An ultimate disassembly framework for binary analysis and reversing.

%package -n libcapstone-devel
Summary: Development files for %name
Provides: capstone-devel = %EVR
Obsoletes: capstone-devel < %EVR
Requires: lib%name%sover = %EVR
Group: Development/C
%description -n libcapstone-devel
An ultimate disassembly framework for binary analysis and reversing.
This package contains libraries and headers for developing.

%package -n python3-module-%name
Summary: Python3 bindings for %name
Requires: lib%name%sover = %EVR
Group: Development/Python3
%description -n python3-module-%name
An ultimate disassembly framework for binary analysis and reversing.
This package contains python 3 bindings for %name.

%package java
Summary: Java bindings for %name
Requires: %name = %EVR
Group: Development/Java
BuildArch: noarch
%description java
An ultimate disassembly framework for binary analysis and reversing.
This package contains java bindings for %name.

%prep
%setup
%autopatch -p1

%build
export PYTHON2="%__python"
export PYTHON3="%__python3"
# ln is required to build cstool dynamically
ln -s libcapstone.so libcapstone.so.${RPM_PACKAGE_VERSION%%%%.*}
DESTDIR=%buildroot CFLAGS="%optflags" LIBDIRARCH=%_lib INCDIR="%_includedir" %make_build V=1

# fix the pkgconfig file
sed -i 's;%buildroot;;' capstone.pc
# remove static libs entry from the pkgconfig file
sed -i 's;archive.*;;' capstone.pc
# remove temporary fuzzallcorp test from 'check:' in Makefile
sed -E -i 's;^(check:.*)fuzzallcorp;\1;g' Makefile

# python bindings
pushd bindings/python
%python3_build
popd

# java bindings
pushd bindings/java
make CFLAGS="%optflags"
popd

%install
DESTDIR=%buildroot LIBDIRARCH=%_lib INCDIR=%_includedir make install V=1
rm -f %buildroot%_libdir/libcapstone.a

# python bindings
pushd bindings/python
%python3_install --install-lib %python3_sitelibdir
popd

# java bindings
install -D -p -m 0644 bindings/java/%name.jar %buildroot%_javadir/%name.jar

%check
export LD_LIBRARY_PATH=%buildroot%_libdir PATH=%buildroot%_bindir:$PATH
make check

ldd %buildroot%_bindir/cstool | grep -F %_libdir/libcapstone.so.
cstool -v
cstool -d x64 90

%files
%doc cstool/README LICENSE.TXT docs
%_bindir/cstool

%files -n lib%name%sover
%_libdir/*.so.%sover

%files -n libcapstone-devel
%doc LICENSE.TXT ChangeLog CREDITS.TXT README.md RELEASE_NOTES
%_includedir/capstone
%_libdir/pkgconfig/%name.pc
%_libdir/*.so

%files -n python3-module-%name
%python3_sitelibdir/*egg-info
%python3_sitelibdir/%name

%files java
%_javadir/*.jar

%changelog
