# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: capnproto
Version: 1.1.0
Release: alt1
Summary: A data interchange format and capability-based RPC system
Group: Development/C
License: MIT
Url: https://capnproto.org
Vcs: https://github.com/capnproto/capnproto
Requires: libcapnp = %EVR

Source: %name-%version.tar
Patch2000: %name-e2k.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
BuildRequires: ctest
BuildRequires: gcc-c++
BuildRequires: libssl-devel
BuildRequires: zlib-devel

%description
Cap'n Proto is data interchange format and capability-based RPC system.
Think JSON, except binary. Or think Protocol Buffers, except faster.

This package contains the schema compiler and command-line encoder and
decoder tools.

%package -n libcapnp
Summary: Shared libraries for %name
Group: System/Libraries
Obsoletes: capnproto-libs < %EVR

%description -n libcapnp
The libcapnp package contains the libraries for using Cap'n Proto
in applications.

# Two step rename to libcapnp-devel because of BR and unmets at the same time.
# When there is capnproto-devel and libcapnp-devel at the same time apt will
# install capnproto-devel.
%package devel
Summary: Development files for %name
Group: Development/C
Provides: libcapnp-devel = %EVR
Requires: capnproto = %EVR
Requires: libcapnp = %EVR

%description devel
This package contains libraries and header files for developing applications
that use Cap'n Proto.

%prep
%setup -n %name-%version/c++
%ifarch %e2k
%patch2000 -p2
%endif

%build
# Disable LTO: https://github.com/capnproto/capnproto/issues/1660
%define optflags_lto %nil
%ifarch %e2k
# too many warnings of this type on tests
%add_optflags -Wno-unused-variable
%endif
%add_optflags %(getconf LFS_CFLAGS) -Wno-tautological-compare
# Upstream build flags.
%add_optflags -Wno-strict-aliasing -Wno-sign-compare -Wno-unused-parameter
%autoreconf
%configure --disable-static
%make_build

%install
%makeinstall_std

%check
# disable networking test
subst '/TEST(AsyncIo, SimpleNetwork)/,/^}/s/^/\/\//' src/kj/async-io-test.c++
# AsyncIo/AncillaryMessageHandler test will fail on older kernels (such as
# 4.9.56-std-def-alt1.1), but is not important and could be ignored, for
# details look at https://github.com/capnproto/capnproto/issues/1349
subst '/TEST(AsyncIo, AncillaryMessageHandler)/,/^}/s/^/\/\//' src/kj/async-io-test.c++
%make_build check

%files
%_bindir/cap*

%files -n libcapnp
%doc ../LICENSE ../CONTRIBUTORS ../README.md
%_libdir/*-%version.so

%files devel
%doc LICENSE.txt README.txt ../doc/*md ../kjdoc/tour.md
%_includedir/*
%_libdir/pkgconfig/*.pc
%_libdir/cmake/CapnProto
%exclude %_libdir/*-%version.so
%_libdir/lib*.so

%changelog
