%define _iconsscaldir  %_iconsdir/hicolor/scalable/apps

Name: byobu
Version: 6.13
Release: alt1

Summary: Light-weight, configurable window manager built upon GNU screen

License: GPLv3
Group: Terminals
Url: https://www.byobu.org/

BuildArch: noarch

Obsoletes: screen-profiles

# Source-url: https://github.com/dustinkirkland/byobu/archive/refs/tags/%version.tar.gz
Source: %name-%version.tar

Patch1: byobu-python.patch

%filter_from_requires /\/etc\/eucalyptus\/eucalyptus.conf/d
# optional
%filter_from_requires /\/sbin\/iwconfig/d
%filter_from_requires /\/bin\/tmux/d
%filter_from_requires /\/bin\/screen/d
%filter_from_requires /\/usr\/sbin\/ioreg/d
%filter_from_requires /\/usr\/sbin\/sysctl/d

%filter_from_requires /snapd/d
%filter_from_requires /dpkg/d

BuildRequires: rpm-build-python3
BuildRequires: desktop-file-utils

%description
Byobu is a GPLv3 open source text-based window manager and terminal multiplexer.
It was originally designed to provide elegant enhancements to the otherwise functional,
plain, practical GNU Screen, for the Ubuntu server distribution.
Byobu now includes an enhanced profiles, convenient keybindings,
configuration utilities, and toggle-able system status notifications
for both the GNU Screen window manager and the more modern Tmux terminal multiplexer,
and works on most Linux, BSD, and Mac distributions.

%prep
%setup
%patch1 -p2

rm -fv usr/bin/*.swp

%build
%autoreconf
%configure
%make_build

%install
%makeinstall_std
rm -rv %buildroot%_sysconfdir/profile.d
rm -v %buildroot/%_libexecdir/%name/apport
%__subst 's#status\[\"apport\"\]=0##g' %buildroot%_bindir/byobu-config

for po in po/*.po
do
    lang=${po#po/}
    lang=${lang%.po}
    mkdir -p %buildroot%_datadir/locale/${lang}/LC_MESSAGES/
    msgfmt ${po} -o %buildroot%_datadir/locale/${lang}/LC_MESSAGES/%name.mo
done

#use the old xterm .desktop style for while
cp -a usr/share/%{name}/desktop/%{name}.desktop.old usr/share/%{name}/desktop/%{name}.desktop
desktop-file-install usr/share/%{name}/desktop/%{name}.desktop --dir %{buildroot}%{_datadir}/applications

# remove vigpg
rm %buildroot%_bindir/vigpg
rm %buildroot%_man1dir/vigpg.1

# add icon into %_iconsdir/hicolor/scalable/apps/ from %_datadir/byobu/pixmaps/byobu.svg
mkdir -p %buildroot%_iconsscaldir
cp -p usr/share/byobu/pixmaps/byobu.svg %buildroot%_iconsscaldir

%find_lang %name

%files -f %name.lang
%_docdir/%name/
%config %_sysconfdir/%name
%_bindir/*
%_datadir/%name
%_man1dir/*
%_libexecdir/%name/
%_desktopdir/%name.desktop
%_datadir/dbus-1/services/us.kirkland.terminals.byobu.service
%_iconsscaldir/*.svg

%changelog
